/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.labels.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.labels.HighLowItemLabelGenerator;

public class HighLowItemLabelGeneratorTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(HighLowItemLabelGeneratorTests.class);
    }

    public HighLowItemLabelGeneratorTests(String name) {
        super(name);
    }

    public void testEquals() {
        HighLowItemLabelGenerator g1 = new HighLowItemLabelGenerator();
        HighLowItemLabelGenerator g2 = new HighLowItemLabelGenerator();
        HighLowItemLabelGeneratorTests.assertTrue((boolean)g1.equals(g2));
        HighLowItemLabelGeneratorTests.assertTrue((boolean)g2.equals(g1));
        g1 = new HighLowItemLabelGenerator(new SimpleDateFormat("d-MMM-yyyy"), NumberFormat.getInstance());
        HighLowItemLabelGeneratorTests.assertFalse((boolean)g1.equals(g2));
        g2 = new HighLowItemLabelGenerator(new SimpleDateFormat("d-MMM-yyyy"), NumberFormat.getInstance());
        HighLowItemLabelGeneratorTests.assertTrue((boolean)g1.equals(g2));
        g1 = new HighLowItemLabelGenerator(new SimpleDateFormat("d-MMM-yyyy"), new DecimalFormat("0.000"));
        HighLowItemLabelGeneratorTests.assertFalse((boolean)g1.equals(g2));
        g2 = new HighLowItemLabelGenerator(new SimpleDateFormat("d-MMM-yyyy"), new DecimalFormat("0.000"));
        HighLowItemLabelGeneratorTests.assertTrue((boolean)g1.equals(g2));
    }

    public void testCloning() {
        HighLowItemLabelGenerator g1 = new HighLowItemLabelGenerator();
        HighLowItemLabelGenerator g2 = null;
        try {
            g2 = (HighLowItemLabelGenerator)g1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        HighLowItemLabelGeneratorTests.assertTrue((g1 != g2 ? 1 : 0) != 0);
        HighLowItemLabelGeneratorTests.assertTrue((g1.getClass() == g2.getClass() ? 1 : 0) != 0);
        HighLowItemLabelGeneratorTests.assertTrue((boolean)g1.equals(g2));
    }

    public void testSerialization() {
        HighLowItemLabelGenerator g1 = new HighLowItemLabelGenerator();
        HighLowItemLabelGenerator g2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(g1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            g2 = (HighLowItemLabelGenerator)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        HighLowItemLabelGeneratorTests.assertEquals((Object)g1, g2);
    }
}

