/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.junit;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.ChartChangeEvent;
import org.jfree.chart.event.ChartChangeListener;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.urls.CategoryURLGenerator;
import org.jfree.chart.urls.StandardCategoryURLGenerator;
import org.jfree.data.Range;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.DatasetUtilities;

public class LineChart3DTests
extends TestCase {
    private JFreeChart chart;

    public static Test suite() {
        return new TestSuite(LineChart3DTests.class);
    }

    public LineChart3DTests(String name) {
        super(name);
    }

    protected void setUp() {
        this.chart = LineChart3DTests.createLineChart3D();
    }

    public void testDrawWithNullInfo() {
        boolean success = false;
        try {
            BufferedImage image = new BufferedImage(200, 100, 1);
            Graphics2D g2 = image.createGraphics();
            this.chart.draw(g2, new Rectangle2D.Double(0.0, 0.0, 200.0, 100.0), null, null);
            g2.dispose();
            success = true;
        }
        catch (Exception e) {
            success = false;
        }
        LineChart3DTests.assertTrue((boolean)success);
    }

    public void testReplaceDataset() {
        Number[][] data = new Integer[][]{{new Integer(-30), new Integer(-20)}, {new Integer(-10), new Integer(10)}, {new Integer(20), new Integer(30)}};
        CategoryDataset newData = DatasetUtilities.createCategoryDataset("S", "C", data);
        LocalListener l = new LocalListener();
        this.chart.addChangeListener(l);
        this.chart.getCategoryPlot().setDataset(newData);
        LineChart3DTests.assertEquals((boolean)true, (boolean)l.flag);
        ValueAxis axis = this.chart.getCategoryPlot().getRangeAxis();
        Range range = axis.getRange();
        LineChart3DTests.assertTrue((String)("Expecting the lower bound of the range to be around -30: " + range.getLowerBound()), (range.getLowerBound() <= -30.0 ? 1 : 0) != 0);
        LineChart3DTests.assertTrue((String)("Expecting the upper bound of the range to be around 30: " + range.getUpperBound()), (range.getUpperBound() >= 30.0 ? 1 : 0) != 0);
    }

    public void testSetSeriesToolTipGenerator() {
        CategoryPlot plot = (CategoryPlot)this.chart.getPlot();
        CategoryItemRenderer renderer = plot.getRenderer();
        StandardCategoryToolTipGenerator tt = new StandardCategoryToolTipGenerator();
        renderer.setSeriesToolTipGenerator(0, tt);
        CategoryToolTipGenerator tt2 = renderer.getToolTipGenerator(0, 0);
        LineChart3DTests.assertTrue((tt2 == tt ? 1 : 0) != 0);
    }

    public void testSetSeriesURLGenerator() {
        CategoryPlot plot = (CategoryPlot)this.chart.getPlot();
        CategoryItemRenderer renderer = plot.getRenderer();
        StandardCategoryURLGenerator url1 = new StandardCategoryURLGenerator();
        renderer.setSeriesItemURLGenerator(0, url1);
        CategoryURLGenerator url2 = renderer.getItemURLGenerator(0, 0);
        LineChart3DTests.assertTrue((url2 == url1 ? 1 : 0) != 0);
    }

    private static JFreeChart createLineChart3D() {
        Number[][] data = new Integer[][]{{new Integer(-3), new Integer(-2)}, {new Integer(-1), new Integer(1)}, {new Integer(2), new Integer(3)}};
        CategoryDataset dataset = DatasetUtilities.createCategoryDataset("S", "C", data);
        return ChartFactory.createLineChart3D("Line Chart", "Domain", "Range", dataset, PlotOrientation.HORIZONTAL, true, true, true);
    }

    static class LocalListener
    implements ChartChangeListener {
        private boolean flag = false;

        LocalListener() {
        }

        public void chartChanged(ChartChangeEvent event) {
            this.flag = true;
        }
    }
}

