/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.entity.junit;

import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.entity.PieSectionEntity;
import org.jfree.data.general.DefaultPieDataset;

public class PieSectionEntityTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(PieSectionEntityTests.class);
    }

    public PieSectionEntityTests(String name) {
        super(name);
    }

    public void testEquals() {
        PieSectionEntity e1 = new PieSectionEntity(new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0), new DefaultPieDataset(), 1, 2, (Comparable)((Object)"Key"), "ToolTip", "URL");
        PieSectionEntity e2 = new PieSectionEntity(new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0), new DefaultPieDataset(), 1, 2, (Comparable)((Object)"Key"), "ToolTip", "URL");
        PieSectionEntityTests.assertTrue((boolean)e1.equals(e2));
        e1.setArea(new Rectangle2D.Double(4.0, 3.0, 2.0, 1.0));
        PieSectionEntityTests.assertFalse((boolean)e1.equals(e2));
        e2.setArea(new Rectangle2D.Double(4.0, 3.0, 2.0, 1.0));
        PieSectionEntityTests.assertTrue((boolean)e1.equals(e2));
        e1.setToolTipText("New ToolTip");
        PieSectionEntityTests.assertFalse((boolean)e1.equals(e2));
        e2.setToolTipText("New ToolTip");
        PieSectionEntityTests.assertTrue((boolean)e1.equals(e2));
        e1.setURLText("New URL");
        PieSectionEntityTests.assertFalse((boolean)e1.equals(e2));
        e2.setURLText("New URL");
        PieSectionEntityTests.assertTrue((boolean)e1.equals(e2));
    }

    public void testCloning() {
        PieSectionEntity e1 = new PieSectionEntity(new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0), new DefaultPieDataset(), 1, 2, (Comparable)((Object)"Key"), "ToolTip", "URL");
        PieSectionEntity e2 = null;
        try {
            e2 = (PieSectionEntity)e1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        PieSectionEntityTests.assertTrue((e1 != e2 ? 1 : 0) != 0);
        PieSectionEntityTests.assertTrue((e1.getClass() == e2.getClass() ? 1 : 0) != 0);
        PieSectionEntityTests.assertTrue((boolean)e1.equals(e2));
    }

    public void testSerialization() {
        PieSectionEntity e1 = new PieSectionEntity(new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0), new DefaultPieDataset(), 1, 2, (Comparable)((Object)"Key"), "ToolTip", "URL");
        PieSectionEntity e2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(e1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            e2 = (PieSectionEntity)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        PieSectionEntityTests.assertEquals((Object)e1, e2);
    }
}

