/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.block.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.block.EmptyBlock;

public class EmptyBlockTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(EmptyBlockTests.class);
    }

    public EmptyBlockTests(String name) {
        super(name);
    }

    public void testEquals() {
        EmptyBlock b1 = new EmptyBlock(1.0, 2.0);
        EmptyBlock b2 = new EmptyBlock(1.0, 2.0);
        EmptyBlockTests.assertTrue((boolean)b1.equals(b2));
        EmptyBlockTests.assertTrue((boolean)b2.equals(b2));
        b1 = new EmptyBlock(1.1, 2.0);
        EmptyBlockTests.assertFalse((boolean)b1.equals(b2));
        b2 = new EmptyBlock(1.1, 2.0);
        EmptyBlockTests.assertTrue((boolean)b1.equals(b2));
        b1 = new EmptyBlock(1.1, 2.2);
        EmptyBlockTests.assertFalse((boolean)b1.equals(b2));
        b2 = new EmptyBlock(1.1, 2.2);
        EmptyBlockTests.assertTrue((boolean)b1.equals(b2));
    }

    public void testCloning() {
        EmptyBlock b1 = new EmptyBlock(1.0, 2.0);
        EmptyBlock b2 = null;
        try {
            b2 = (EmptyBlock)b1.clone();
        }
        catch (CloneNotSupportedException e) {
            EmptyBlockTests.fail((String)e.toString());
        }
        EmptyBlockTests.assertTrue((b1 != b2 ? 1 : 0) != 0);
        EmptyBlockTests.assertTrue((b1.getClass() == b2.getClass() ? 1 : 0) != 0);
        EmptyBlockTests.assertTrue((boolean)b1.equals(b2));
    }

    public void testSerialization() {
        EmptyBlock b1 = new EmptyBlock(1.0, 2.0);
        EmptyBlock b2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(b1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            b2 = (EmptyBlock)in.readObject();
            in.close();
        }
        catch (Exception e) {
            EmptyBlockTests.fail((String)e.toString());
        }
        EmptyBlockTests.assertEquals((Object)b1, b2);
    }
}

