/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.block.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.block.ColumnArrangement;
import org.jfree.chart.block.FlowArrangement;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.VerticalAlignment;

public class ColumnArrangementTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(ColumnArrangementTests.class);
    }

    public ColumnArrangementTests(String name) {
        super(name);
    }

    public void testEquals() {
        ColumnArrangement c1 = new ColumnArrangement(HorizontalAlignment.LEFT, VerticalAlignment.TOP, 1.0, 2.0);
        ColumnArrangement c2 = new ColumnArrangement(HorizontalAlignment.LEFT, VerticalAlignment.TOP, 1.0, 2.0);
        ColumnArrangementTests.assertTrue((boolean)c1.equals(c2));
        ColumnArrangementTests.assertTrue((boolean)c2.equals(c1));
        c1 = new ColumnArrangement(HorizontalAlignment.RIGHT, VerticalAlignment.TOP, 1.0, 2.0);
        ColumnArrangementTests.assertFalse((boolean)c1.equals(c2));
        c2 = new ColumnArrangement(HorizontalAlignment.RIGHT, VerticalAlignment.TOP, 1.0, 2.0);
        ColumnArrangementTests.assertTrue((boolean)c1.equals(c2));
        c1 = new ColumnArrangement(HorizontalAlignment.RIGHT, VerticalAlignment.BOTTOM, 1.0, 2.0);
        ColumnArrangementTests.assertFalse((boolean)c1.equals(c2));
        c2 = new ColumnArrangement(HorizontalAlignment.RIGHT, VerticalAlignment.BOTTOM, 1.0, 2.0);
        ColumnArrangementTests.assertTrue((boolean)c1.equals(c2));
        c1 = new ColumnArrangement(HorizontalAlignment.RIGHT, VerticalAlignment.BOTTOM, 1.1, 2.0);
        ColumnArrangementTests.assertFalse((boolean)c1.equals(c2));
        c2 = new ColumnArrangement(HorizontalAlignment.RIGHT, VerticalAlignment.BOTTOM, 1.1, 2.0);
        ColumnArrangementTests.assertTrue((boolean)c1.equals(c2));
        c1 = new ColumnArrangement(HorizontalAlignment.RIGHT, VerticalAlignment.BOTTOM, 1.1, 2.2);
        ColumnArrangementTests.assertFalse((boolean)c1.equals(c2));
        c2 = new ColumnArrangement(HorizontalAlignment.RIGHT, VerticalAlignment.BOTTOM, 1.1, 2.2);
        ColumnArrangementTests.assertTrue((boolean)c1.equals(c2));
    }

    public void testCloning() {
        FlowArrangement f1 = new FlowArrangement();
        ColumnArrangementTests.assertFalse((boolean)(f1 instanceof Cloneable));
    }

    public void testSerialization() {
        FlowArrangement f1 = new FlowArrangement(HorizontalAlignment.LEFT, VerticalAlignment.TOP, 1.0, 2.0);
        FlowArrangement f2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(f1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            f2 = (FlowArrangement)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        ColumnArrangementTests.assertEquals((Object)f1, f2);
    }
}

