/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.block.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.block.BlockContainer;
import org.jfree.chart.block.ColumnArrangement;
import org.jfree.chart.block.EmptyBlock;
import org.jfree.chart.block.FlowArrangement;

public class BlockContainerTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(BlockContainerTests.class);
    }

    public BlockContainerTests(String name) {
        super(name);
    }

    public void testEquals() {
        BlockContainer c1 = new BlockContainer(new FlowArrangement());
        BlockContainer c2 = new BlockContainer(new FlowArrangement());
        BlockContainerTests.assertTrue((boolean)c1.equals(c2));
        BlockContainerTests.assertTrue((boolean)c2.equals(c2));
        c1.setArrangement(new ColumnArrangement());
        BlockContainerTests.assertFalse((boolean)c1.equals(c2));
        c2.setArrangement(new ColumnArrangement());
        BlockContainerTests.assertTrue((boolean)c1.equals(c2));
        c1.add(new EmptyBlock(1.2, 3.4));
        BlockContainerTests.assertFalse((boolean)c1.equals(c2));
        c2.add(new EmptyBlock(1.2, 3.4));
        BlockContainerTests.assertTrue((boolean)c1.equals(c2));
    }

    public void testCloning() {
        BlockContainer c1 = new BlockContainer(new FlowArrangement());
        c1.add(new EmptyBlock(1.2, 3.4));
        BlockContainer c2 = null;
        try {
            c2 = (BlockContainer)c1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        BlockContainerTests.assertTrue((c1 != c2 ? 1 : 0) != 0);
        BlockContainerTests.assertTrue((c1.getClass() == c2.getClass() ? 1 : 0) != 0);
        BlockContainerTests.assertTrue((boolean)c1.equals(c2));
    }

    public void testSerialization() {
        BlockContainer c1 = new BlockContainer();
        c1.add(new EmptyBlock(1.2, 3.4));
        BlockContainer c2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(c1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            c2 = (BlockContainer)in.readObject();
            in.close();
        }
        catch (Exception e) {
            BlockContainerTests.fail((String)e.toString());
        }
        BlockContainerTests.assertEquals((Object)c1, c2);
    }
}

