/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.block;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.block.AbstractBlock;
import org.jfree.chart.block.Block;
import org.jfree.chart.block.BlockResult;
import org.jfree.chart.block.EntityBlockParams;
import org.jfree.chart.block.RectangleConstraint;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.StandardEntityCollection;
import org.jfree.text.TextBlock;
import org.jfree.text.TextBlockAnchor;
import org.jfree.text.TextUtilities;
import org.jfree.ui.Size2D;

public class LabelBlock
extends AbstractBlock
implements Block {
    private String text;
    private TextBlock label;
    private Font font;
    private Paint paint = Color.black;
    private String toolTipText;
    private String urlText;

    public LabelBlock(String label) {
        this(label, new Font("SansSerif", 0, 10));
    }

    public LabelBlock(String text, Font font) {
        this.text = text;
        this.label = TextUtilities.createTextBlock((String)text, (Font)font, (Paint)Color.black);
        this.font = font;
        this.toolTipText = null;
        this.urlText = null;
    }

    public LabelBlock(String text, Font font, Paint paint) {
        this.text = text;
        this.label = TextUtilities.createTextBlock((String)text, (Font)font, (Paint)paint);
        this.font = font;
        this.toolTipText = null;
        this.urlText = null;
    }

    public Font getFont() {
        return this.font;
    }

    public void setPaint(Paint paint) {
        this.paint = paint;
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setFont(Font font) {
        this.font = font;
        this.label = TextUtilities.createTextBlock((String)this.text, (Font)font, (Paint)this.paint);
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    public void setToolTipText(String text) {
        this.toolTipText = text;
    }

    public String getURLText() {
        return this.urlText;
    }

    public void setURLText(String text) {
        this.urlText = text;
    }

    public Size2D arrange(Graphics2D g2, RectangleConstraint constraint) {
        RectangleConstraint contentConstraint = this.toContentConstraint(constraint);
        g2.setFont(this.font);
        Size2D s = this.label.calculateDimensions(g2);
        return new Size2D(this.calculateTotalWidth(s.getWidth()), this.calculateTotalHeight(s.getHeight()));
    }

    public void draw(Graphics2D g2, Rectangle2D area) {
        this.draw(g2, area, null);
    }

    public Object draw(Graphics2D g2, Rectangle2D area, Object params) {
        area = this.trimMargin(area);
        this.drawBorder(g2, area);
        area = this.trimBorder(area);
        area = this.trimPadding(area);
        EntityBlockParams ebp = null;
        StandardEntityCollection sec = null;
        Shape entityArea = null;
        if (params instanceof EntityBlockParams && (ebp = (EntityBlockParams)params).getGenerateEntities()) {
            sec = new StandardEntityCollection();
            entityArea = g2.getTransform().createTransformedShape(area);
        }
        g2.setPaint(Color.black);
        g2.setFont(this.font);
        this.label.draw(g2, (float)area.getX(), (float)area.getY(), TextBlockAnchor.TOP_LEFT);
        BlockResult result = null;
        if (ebp != null && sec != null && (this.toolTipText != null || this.urlText != null)) {
            ChartEntity entity = new ChartEntity(entityArea, this.toolTipText, this.urlText);
            sec.add(entity);
            result = new BlockResult();
            result.setEntityCollection(sec);
        }
        return result;
    }
}

