/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis.junit;

import java.awt.Color;
import java.awt.Font;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.axis.SubCategoryAxis;
import org.jfree.chart.axis.junit.CategoryAxisTests;

public class SubCategoryAxisTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(CategoryAxisTests.class);
    }

    public SubCategoryAxisTests(String name) {
        super(name);
    }

    public void testEquals() {
        SubCategoryAxis a1 = new SubCategoryAxis("Test");
        SubCategoryAxis a2 = new SubCategoryAxis("Test");
        SubCategoryAxisTests.assertTrue((boolean)a1.equals(a2));
        SubCategoryAxisTests.assertTrue((boolean)a2.equals(a1));
        a1.addSubCategory((Comparable)((Object)"Sub 1"));
        SubCategoryAxisTests.assertFalse((boolean)a1.equals(a2));
        a2.addSubCategory((Comparable)((Object)"Sub 1"));
        SubCategoryAxisTests.assertTrue((boolean)a1.equals(a2));
        a1.setSubLabelFont(new Font("Serif", 1, 15));
        SubCategoryAxisTests.assertFalse((boolean)a1.equals(a2));
        a2.setSubLabelFont(new Font("Serif", 1, 15));
        SubCategoryAxisTests.assertTrue((boolean)a1.equals(a2));
        a1.setSubLabelPaint(Color.red);
        SubCategoryAxisTests.assertFalse((boolean)a1.equals(a2));
        a2.setSubLabelPaint(Color.red);
        SubCategoryAxisTests.assertTrue((boolean)a1.equals(a2));
    }

    public void testHashCode() {
        SubCategoryAxis a1 = new SubCategoryAxis("Test");
        SubCategoryAxis a2 = new SubCategoryAxis("Test");
        SubCategoryAxisTests.assertTrue((boolean)a1.equals(a2));
        int h1 = a1.hashCode();
        int h2 = a2.hashCode();
        SubCategoryAxisTests.assertEquals((int)h1, (int)h2);
    }

    public void testCloning() {
        SubCategoryAxis a1 = new SubCategoryAxis("Test");
        SubCategoryAxis a2 = null;
        try {
            a2 = (SubCategoryAxis)a1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        SubCategoryAxisTests.assertTrue((a1 != a2 ? 1 : 0) != 0);
        SubCategoryAxisTests.assertTrue((a1.getClass() == a2.getClass() ? 1 : 0) != 0);
        SubCategoryAxisTests.assertTrue((boolean)a1.equals(a2));
    }

    public void testSerialization() {
        SubCategoryAxis a1 = new SubCategoryAxis("Test Axis");
        SubCategoryAxis a2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(a1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            a2 = (SubCategoryAxis)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        SubCategoryAxisTests.assertEquals((Object)a1, a2);
    }
}

