/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis.junit;

import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DecimalFormat;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.RectangleEdge;

public class NumberAxisTests
extends TestCase {
    private static final double EPSILON = 1.0E-7;

    public static Test suite() {
        return new TestSuite(NumberAxisTests.class);
    }

    public NumberAxisTests(String name) {
        super(name);
    }

    public void testCloning() {
        NumberAxis a1 = new NumberAxis("Test");
        NumberAxis a2 = null;
        try {
            a2 = (NumberAxis)a1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        NumberAxisTests.assertTrue((a1 != a2 ? 1 : 0) != 0);
        NumberAxisTests.assertTrue((a1.getClass() == a2.getClass() ? 1 : 0) != 0);
        NumberAxisTests.assertTrue((boolean)a1.equals(a2));
    }

    public void testEquals() {
        NumberAxis a1 = new NumberAxis("Test");
        NumberAxis a2 = new NumberAxis("Test");
        NumberAxisTests.assertTrue((boolean)a1.equals(a2));
        a1.setAutoRangeIncludesZero(false);
        NumberAxisTests.assertFalse((boolean)a1.equals(a2));
        a2.setAutoRangeIncludesZero(false);
        NumberAxisTests.assertTrue((boolean)a1.equals(a2));
        a1.setAutoRangeStickyZero(false);
        NumberAxisTests.assertFalse((boolean)a1.equals(a2));
        a2.setAutoRangeStickyZero(false);
        NumberAxisTests.assertTrue((boolean)a1.equals(a2));
        a1.setTickUnit(new NumberTickUnit(25.0));
        NumberAxisTests.assertFalse((boolean)a1.equals(a2));
        a2.setTickUnit(new NumberTickUnit(25.0));
        NumberAxisTests.assertTrue((boolean)a1.equals(a2));
        a1.setNumberFormatOverride(new DecimalFormat("0.00"));
        NumberAxisTests.assertFalse((boolean)a1.equals(a2));
        a2.setNumberFormatOverride(new DecimalFormat("0.00"));
        NumberAxisTests.assertTrue((boolean)a1.equals(a2));
    }

    public void testHashCode() {
        NumberAxis a1 = new NumberAxis("Test");
        NumberAxis a2 = new NumberAxis("Test");
        NumberAxisTests.assertTrue((boolean)a1.equals(a2));
        int h1 = a1.hashCode();
        int h2 = a2.hashCode();
        NumberAxisTests.assertEquals((int)h1, (int)h2);
    }

    public void testTranslateJava2DToValue() {
        NumberAxis axis = new NumberAxis();
        axis.setRange(50.0, 100.0);
        Rectangle2D.Double dataArea = new Rectangle2D.Double(10.0, 50.0, 400.0, 300.0);
        double y1 = axis.java2DToValue(75.0, dataArea, RectangleEdge.LEFT);
        NumberAxisTests.assertEquals((double)y1, (double)95.8333333, (double)1.0E-7);
        double y2 = axis.java2DToValue(75.0, dataArea, RectangleEdge.RIGHT);
        NumberAxisTests.assertEquals((double)y2, (double)95.8333333, (double)1.0E-7);
        double x1 = axis.java2DToValue(75.0, dataArea, RectangleEdge.TOP);
        NumberAxisTests.assertEquals((double)x1, (double)58.125, (double)1.0E-7);
        double x2 = axis.java2DToValue(75.0, dataArea, RectangleEdge.BOTTOM);
        NumberAxisTests.assertEquals((double)x2, (double)58.125, (double)1.0E-7);
        axis.setInverted(true);
        double y3 = axis.java2DToValue(75.0, dataArea, RectangleEdge.LEFT);
        NumberAxisTests.assertEquals((double)y3, (double)54.1666667, (double)1.0E-7);
        double y4 = axis.java2DToValue(75.0, dataArea, RectangleEdge.RIGHT);
        NumberAxisTests.assertEquals((double)y4, (double)54.1666667, (double)1.0E-7);
        double x3 = axis.java2DToValue(75.0, dataArea, RectangleEdge.TOP);
        NumberAxisTests.assertEquals((double)x3, (double)91.875, (double)1.0E-7);
        double x4 = axis.java2DToValue(75.0, dataArea, RectangleEdge.BOTTOM);
        NumberAxisTests.assertEquals((double)x4, (double)91.875, (double)1.0E-7);
    }

    public void testSerialization() {
        NumberAxis a1 = new NumberAxis("Test Axis");
        NumberAxis a2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(a1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            a2 = (NumberAxis)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        NumberAxisTests.assertEquals((Object)a1, a2);
    }

    public void testAutoRange1() {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        dataset.setValue(100.0, (Comparable)((Object)"Row 1"), (Comparable)((Object)"Column 1"));
        dataset.setValue(200.0, (Comparable)((Object)"Row 1"), (Comparable)((Object)"Column 2"));
        JFreeChart chart = ChartFactory.createBarChart("Test", "Categories", "Value", dataset, PlotOrientation.VERTICAL, false, false, false);
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        NumberAxis axis = (NumberAxis)plot.getRangeAxis();
        NumberAxisTests.assertEquals((double)axis.getLowerBound(), (double)0.0, (double)1.0E-7);
        NumberAxisTests.assertEquals((double)axis.getUpperBound(), (double)210.0, (double)1.0E-7);
    }

    public void testAutoRange2() {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        dataset.setValue(100.0, (Comparable)((Object)"Row 1"), (Comparable)((Object)"Column 1"));
        dataset.setValue(200.0, (Comparable)((Object)"Row 1"), (Comparable)((Object)"Column 2"));
        JFreeChart chart = ChartFactory.createBarChart("Test", "Categories", "Value", dataset, PlotOrientation.VERTICAL, false, false, false);
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        NumberAxis axis = (NumberAxis)plot.getRangeAxis();
        axis.setAutoRangeIncludesZero(false);
        NumberAxisTests.assertEquals((double)axis.getLowerBound(), (double)95.0, (double)1.0E-7);
        NumberAxisTests.assertEquals((double)axis.getUpperBound(), (double)205.0, (double)1.0E-7);
    }

    public void testAutoRange3() {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        dataset.setValue(100.0, (Comparable)((Object)"Row 1"), (Comparable)((Object)"Column 1"));
        dataset.setValue(200.0, (Comparable)((Object)"Row 1"), (Comparable)((Object)"Column 2"));
        JFreeChart chart = ChartFactory.createBarChart("Test", "Categories", "Value", dataset, PlotOrientation.VERTICAL, false, false, false);
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        NumberAxis axis = (NumberAxis)plot.getRangeAxis();
        axis.setAutoRangeIncludesZero(false);
        NumberAxisTests.assertEquals((double)axis.getLowerBound(), (double)95.0, (double)1.0E-7);
        NumberAxisTests.assertEquals((double)axis.getUpperBound(), (double)205.0, (double)1.0E-7);
        DefaultCategoryDataset dataset2 = new DefaultCategoryDataset();
        dataset2.setValue(900.0, (Comparable)((Object)"Row 1"), (Comparable)((Object)"Column 1"));
        dataset2.setValue(1000.0, (Comparable)((Object)"Row 1"), (Comparable)((Object)"Column 2"));
        plot.setDataset(dataset2);
        NumberAxisTests.assertEquals((double)axis.getLowerBound(), (double)895.0, (double)1.0E-7);
        NumberAxisTests.assertEquals((double)axis.getUpperBound(), (double)1005.0, (double)1.0E-7);
    }

    public void testXYAutoRange1() {
        XYSeries series = new XYSeries((Comparable)((Object)"Series 1"));
        series.add(1.0, 1.0);
        series.add(2.0, 2.0);
        series.add(3.0, 3.0);
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(series);
        JFreeChart chart = ChartFactory.createScatterPlot("Test", "X", "Y", dataset, PlotOrientation.VERTICAL, false, false, false);
        XYPlot plot = (XYPlot)chart.getPlot();
        NumberAxis axis = (NumberAxis)plot.getDomainAxis();
        axis.setAutoRangeIncludesZero(false);
        NumberAxisTests.assertEquals((double)0.9, (double)axis.getLowerBound(), (double)1.0E-7);
        NumberAxisTests.assertEquals((double)3.1, (double)axis.getUpperBound(), (double)1.0E-7);
    }

    public void testXYAutoRange2() {
        XYSeries series = new XYSeries((Comparable)((Object)"Series 1"));
        series.add(1.0, 1.0);
        series.add(2.0, 2.0);
        series.add(3.0, 3.0);
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(series);
        JFreeChart chart = ChartFactory.createScatterPlot("Test", "X", "Y", dataset, PlotOrientation.VERTICAL, false, false, false);
        XYPlot plot = (XYPlot)chart.getPlot();
        NumberAxis axis = (NumberAxis)plot.getRangeAxis();
        axis.setAutoRangeIncludesZero(false);
        NumberAxisTests.assertEquals((double)0.9, (double)axis.getLowerBound(), (double)1.0E-7);
        NumberAxisTests.assertEquals((double)3.1, (double)axis.getUpperBound(), (double)1.0E-7);
    }
}

