/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.axis.MonthDateFormat;

public class MonthDateFormatTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(MonthDateFormatTests.class);
    }

    public MonthDateFormatTests(String name) {
        super(name);
    }

    public void testEquals() {
        MonthDateFormat mf1 = new MonthDateFormat();
        MonthDateFormat mf2 = new MonthDateFormat();
        MonthDateFormatTests.assertTrue((boolean)mf1.equals(mf2));
        MonthDateFormatTests.assertTrue((boolean)mf2.equals(mf1));
        boolean[] showYear1 = new boolean[12];
        showYear1[0] = true;
        boolean[] showYear2 = new boolean[12];
        showYear1[1] = true;
        mf1 = new MonthDateFormat(TimeZone.getTimeZone("PST"), Locale.US, 1, showYear1, new SimpleDateFormat("yy"));
        MonthDateFormatTests.assertFalse((boolean)mf1.equals(mf2));
        mf2 = new MonthDateFormat(TimeZone.getTimeZone("PST"), Locale.US, 1, showYear1, new SimpleDateFormat("yy"));
        MonthDateFormatTests.assertTrue((boolean)mf1.equals(mf2));
        mf1 = new MonthDateFormat(TimeZone.getTimeZone("PST"), Locale.FRANCE, 1, showYear1, new SimpleDateFormat("yy"));
        MonthDateFormatTests.assertFalse((boolean)mf1.equals(mf2));
        mf2 = new MonthDateFormat(TimeZone.getTimeZone("PST"), Locale.FRANCE, 1, showYear1, new SimpleDateFormat("yy"));
        MonthDateFormatTests.assertTrue((boolean)mf1.equals(mf2));
        mf1 = new MonthDateFormat(TimeZone.getTimeZone("PST"), Locale.FRANCE, 2, showYear1, new SimpleDateFormat("yy"));
        MonthDateFormatTests.assertFalse((boolean)mf1.equals(mf2));
        mf2 = new MonthDateFormat(TimeZone.getTimeZone("PST"), Locale.FRANCE, 2, showYear1, new SimpleDateFormat("yy"));
        MonthDateFormatTests.assertTrue((boolean)mf1.equals(mf2));
        mf1 = new MonthDateFormat(TimeZone.getTimeZone("PST"), Locale.FRANCE, 2, showYear2, new SimpleDateFormat("yy"));
        MonthDateFormatTests.assertFalse((boolean)mf1.equals(mf2));
        mf2 = new MonthDateFormat(TimeZone.getTimeZone("PST"), Locale.FRANCE, 2, showYear2, new SimpleDateFormat("yy"));
        MonthDateFormatTests.assertTrue((boolean)mf1.equals(mf2));
        mf1 = new MonthDateFormat(TimeZone.getTimeZone("PST"), Locale.FRANCE, 2, showYear2, new SimpleDateFormat("yyyy"));
        MonthDateFormatTests.assertFalse((boolean)mf1.equals(mf2));
        mf2 = new MonthDateFormat(TimeZone.getTimeZone("PST"), Locale.FRANCE, 2, showYear2, new SimpleDateFormat("yyyy"));
        MonthDateFormatTests.assertTrue((boolean)mf1.equals(mf2));
    }

    public void testHashCode() {
        MonthDateFormat mf1 = new MonthDateFormat();
        MonthDateFormat mf2 = new MonthDateFormat();
        MonthDateFormatTests.assertTrue((boolean)mf1.equals(mf2));
        int h1 = mf1.hashCode();
        int h2 = mf2.hashCode();
        MonthDateFormatTests.assertEquals((int)h1, (int)h2);
    }

    public void testCloning() {
        MonthDateFormat mf1 = new MonthDateFormat();
        MonthDateFormat mf2 = null;
        mf2 = (MonthDateFormat)mf1.clone();
        MonthDateFormatTests.assertTrue((mf1 != mf2 ? 1 : 0) != 0);
        MonthDateFormatTests.assertTrue((mf1.getClass() == mf2.getClass() ? 1 : 0) != 0);
        MonthDateFormatTests.assertTrue((boolean)mf1.equals(mf2));
    }

    public void testSerialization() {
        MonthDateFormat mf1 = new MonthDateFormat();
        MonthDateFormat mf2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(mf1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            mf2 = (MonthDateFormat)in.readObject();
            in.close();
        }
        catch (Exception e) {
            MonthDateFormatTests.fail((String)e.toString());
        }
        MonthDateFormatTests.assertTrue((boolean)mf1.equals(mf2));
    }
}

