/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.axis.CategoryLabelPosition;
import org.jfree.chart.axis.CategoryLabelWidthType;
import org.jfree.text.TextBlockAnchor;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.TextAnchor;

public class CategoryLabelPositionTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(CategoryLabelPositionTests.class);
    }

    public CategoryLabelPositionTests(String name) {
        super(name);
    }

    public void testEquals() {
        CategoryLabelPosition p1 = new CategoryLabelPosition(RectangleAnchor.BOTTOM_LEFT, TextBlockAnchor.CENTER_RIGHT, TextAnchor.BASELINE_LEFT, 0.7853981633974483, CategoryLabelWidthType.RANGE, 0.44f);
        CategoryLabelPosition p2 = new CategoryLabelPosition(RectangleAnchor.BOTTOM_LEFT, TextBlockAnchor.CENTER_RIGHT, TextAnchor.BASELINE_LEFT, 0.7853981633974483, CategoryLabelWidthType.RANGE, 0.44f);
        CategoryLabelPositionTests.assertTrue((boolean)p1.equals(p2));
        CategoryLabelPositionTests.assertTrue((boolean)p2.equals(p1));
        p1 = new CategoryLabelPosition(RectangleAnchor.TOP, TextBlockAnchor.CENTER_RIGHT, TextAnchor.BASELINE_LEFT, 0.7853981633974483, CategoryLabelWidthType.RANGE, 0.44f);
        CategoryLabelPositionTests.assertFalse((boolean)p1.equals(p2));
        p2 = new CategoryLabelPosition(RectangleAnchor.TOP, TextBlockAnchor.CENTER_RIGHT, TextAnchor.BASELINE_LEFT, 0.7853981633974483, CategoryLabelWidthType.RANGE, 0.44f);
        CategoryLabelPositionTests.assertTrue((boolean)p1.equals(p2));
        p1 = new CategoryLabelPosition(RectangleAnchor.TOP, TextBlockAnchor.CENTER, TextAnchor.BASELINE_LEFT, 0.7853981633974483, CategoryLabelWidthType.RANGE, 0.44f);
        CategoryLabelPositionTests.assertFalse((boolean)p1.equals(p2));
        p2 = new CategoryLabelPosition(RectangleAnchor.TOP, TextBlockAnchor.CENTER, TextAnchor.BASELINE_LEFT, 0.7853981633974483, CategoryLabelWidthType.RANGE, 0.44f);
        CategoryLabelPositionTests.assertTrue((boolean)p1.equals(p2));
        p1 = new CategoryLabelPosition(RectangleAnchor.TOP, TextBlockAnchor.CENTER, TextAnchor.CENTER, 0.7853981633974483, CategoryLabelWidthType.RANGE, 0.44f);
        CategoryLabelPositionTests.assertFalse((boolean)p1.equals(p2));
        p2 = new CategoryLabelPosition(RectangleAnchor.TOP, TextBlockAnchor.CENTER, TextAnchor.CENTER, 0.7853981633974483, CategoryLabelWidthType.RANGE, 0.44f);
        CategoryLabelPositionTests.assertTrue((boolean)p1.equals(p2));
        p1 = new CategoryLabelPosition(RectangleAnchor.TOP, TextBlockAnchor.CENTER, TextAnchor.CENTER, 0.5235987755982988, CategoryLabelWidthType.RANGE, 0.44f);
        CategoryLabelPositionTests.assertFalse((boolean)p1.equals(p2));
        p2 = new CategoryLabelPosition(RectangleAnchor.TOP, TextBlockAnchor.CENTER, TextAnchor.CENTER, 0.5235987755982988, CategoryLabelWidthType.RANGE, 0.44f);
        CategoryLabelPositionTests.assertTrue((boolean)p1.equals(p2));
        p1 = new CategoryLabelPosition(RectangleAnchor.TOP, TextBlockAnchor.CENTER, TextAnchor.CENTER, 0.5235987755982988, CategoryLabelWidthType.CATEGORY, 0.44f);
        CategoryLabelPositionTests.assertFalse((boolean)p1.equals(p2));
        p2 = new CategoryLabelPosition(RectangleAnchor.TOP, TextBlockAnchor.CENTER, TextAnchor.CENTER, 0.5235987755982988, CategoryLabelWidthType.CATEGORY, 0.44f);
        CategoryLabelPositionTests.assertTrue((boolean)p1.equals(p2));
        p1 = new CategoryLabelPosition(RectangleAnchor.TOP, TextBlockAnchor.CENTER, TextAnchor.CENTER, 0.5235987755982988, CategoryLabelWidthType.CATEGORY, 0.55f);
        CategoryLabelPositionTests.assertFalse((boolean)p1.equals(p2));
        p2 = new CategoryLabelPosition(RectangleAnchor.TOP, TextBlockAnchor.CENTER, TextAnchor.CENTER, 0.5235987755982988, CategoryLabelWidthType.CATEGORY, 0.55f);
        CategoryLabelPositionTests.assertTrue((boolean)p1.equals(p2));
    }

    public void testHashCode() {
        CategoryLabelPosition a1 = new CategoryLabelPosition();
        CategoryLabelPosition a2 = new CategoryLabelPosition();
        CategoryLabelPositionTests.assertTrue((boolean)a1.equals(a2));
        int h1 = a1.hashCode();
        int h2 = a2.hashCode();
        CategoryLabelPositionTests.assertEquals((int)h1, (int)h2);
    }

    public void testSerialization() {
        CategoryLabelPosition p1 = new CategoryLabelPosition();
        CategoryLabelPosition p2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(p1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            p2 = (CategoryLabelPosition)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        CategoryLabelPositionTests.assertEquals((Object)p1, p2);
    }
}

