/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.annotations.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.XYImageAnnotation;

public class XYImageAnnotationTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(XYImageAnnotationTests.class);
    }

    public XYImageAnnotationTests(String name) {
        super(name);
    }

    public void testEquals() {
        XYImageAnnotation a1 = new XYImageAnnotation(10.0, 20.0, JFreeChart.INFO.getLogo());
        XYImageAnnotation a2 = new XYImageAnnotation(10.0, 20.0, JFreeChart.INFO.getLogo());
        XYImageAnnotationTests.assertTrue((boolean)a1.equals(a2));
    }

    public void testHashCode() {
        XYImageAnnotation a1 = new XYImageAnnotation(10.0, 20.0, JFreeChart.INFO.getLogo());
        XYImageAnnotation a2 = new XYImageAnnotation(10.0, 20.0, JFreeChart.INFO.getLogo());
        XYImageAnnotationTests.assertTrue((boolean)a1.equals(a2));
        int h1 = a1.hashCode();
        int h2 = a2.hashCode();
        XYImageAnnotationTests.assertEquals((int)h1, (int)h2);
    }

    public void testCloning() {
        XYImageAnnotation a1 = new XYImageAnnotation(10.0, 20.0, JFreeChart.INFO.getLogo());
        XYImageAnnotation a2 = null;
        try {
            a2 = (XYImageAnnotation)a1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        XYImageAnnotationTests.assertTrue((a1 != a2 ? 1 : 0) != 0);
        XYImageAnnotationTests.assertTrue((a1.getClass() == a2.getClass() ? 1 : 0) != 0);
        XYImageAnnotationTests.assertTrue((boolean)a1.equals(a2));
    }

    public void testSerialization() {
        XYImageAnnotation a1 = new XYImageAnnotation(10.0, 20.0, JFreeChart.INFO.getLogo());
        XYImageAnnotation a2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(a1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            a2 = (XYImageAnnotation)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        XYImageAnnotationTests.assertEquals((Object)a1, a2);
    }
}

