/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.annotations.junit;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.annotations.XYDrawableAnnotation;
import org.jfree.ui.Drawable;

public class XYDrawableAnnotationTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(XYDrawableAnnotationTests.class);
    }

    public XYDrawableAnnotationTests(String name) {
        super(name);
    }

    public void testEquals() {
        XYDrawableAnnotation a1 = new XYDrawableAnnotation(10.0, 20.0, 100.0, 200.0, new TestDrawable());
        XYDrawableAnnotation a2 = new XYDrawableAnnotation(10.0, 20.0, 100.0, 200.0, new TestDrawable());
        XYDrawableAnnotationTests.assertTrue((boolean)a1.equals(a2));
    }

    public void testHashCode() {
        XYDrawableAnnotation a1 = new XYDrawableAnnotation(10.0, 20.0, 100.0, 200.0, new TestDrawable());
        XYDrawableAnnotation a2 = new XYDrawableAnnotation(10.0, 20.0, 100.0, 200.0, new TestDrawable());
        XYDrawableAnnotationTests.assertTrue((boolean)a1.equals(a2));
        int h1 = a1.hashCode();
        int h2 = a2.hashCode();
        XYDrawableAnnotationTests.assertEquals((int)h1, (int)h2);
    }

    public void testCloning() {
        XYDrawableAnnotation a1 = new XYDrawableAnnotation(10.0, 20.0, 100.0, 200.0, new TestDrawable());
        XYDrawableAnnotation a2 = null;
        try {
            a2 = (XYDrawableAnnotation)a1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        XYDrawableAnnotationTests.assertTrue((a1 != a2 ? 1 : 0) != 0);
        XYDrawableAnnotationTests.assertTrue((a1.getClass() == a2.getClass() ? 1 : 0) != 0);
        XYDrawableAnnotationTests.assertTrue((boolean)a1.equals(a2));
    }

    public void testSerialization() {
        XYDrawableAnnotation a1 = new XYDrawableAnnotation(10.0, 20.0, 100.0, 200.0, new TestDrawable());
        XYDrawableAnnotation a2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(a1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            a2 = (XYDrawableAnnotation)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        XYDrawableAnnotationTests.assertEquals((Object)a1, a2);
    }

    static class TestDrawable
    implements Drawable,
    Cloneable,
    Serializable {
        public void draw(Graphics2D g2, Rectangle2D area) {
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            return obj instanceof TestDrawable;
        }
    }
}

