/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.annotations.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.annotations.CategoryTextAnnotation;
import org.jfree.chart.axis.CategoryAnchor;

public class CategoryTextAnnotationTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(CategoryTextAnnotationTests.class);
    }

    public CategoryTextAnnotationTests(String name) {
        super(name);
    }

    public void testEquals() {
        CategoryTextAnnotation a1 = new CategoryTextAnnotation("Test", (Comparable)((Object)"Category"), 1.0);
        CategoryTextAnnotation a2 = new CategoryTextAnnotation("Test", (Comparable)((Object)"Category"), 1.0);
        CategoryTextAnnotationTests.assertTrue((boolean)a1.equals(a2));
        a1.setCategory((Comparable)((Object)"Category 2"));
        CategoryTextAnnotationTests.assertFalse((boolean)a1.equals(a2));
        a2.setCategory((Comparable)((Object)"Category 2"));
        CategoryTextAnnotationTests.assertTrue((boolean)a1.equals(a2));
        a1.setCategoryAnchor(CategoryAnchor.START);
        CategoryTextAnnotationTests.assertFalse((boolean)a1.equals(a2));
        a2.setCategoryAnchor(CategoryAnchor.START);
        CategoryTextAnnotationTests.assertTrue((boolean)a1.equals(a2));
        a1.setValue(0.15);
        CategoryTextAnnotationTests.assertFalse((boolean)a1.equals(a2));
        a2.setValue(0.15);
        CategoryTextAnnotationTests.assertTrue((boolean)a1.equals(a2));
    }

    public void testHashcode() {
        CategoryTextAnnotation a1 = new CategoryTextAnnotation("Test", (Comparable)((Object)"Category"), 1.0);
        CategoryTextAnnotation a2 = new CategoryTextAnnotation("Test", (Comparable)((Object)"Category"), 1.0);
        CategoryTextAnnotationTests.assertTrue((boolean)a1.equals(a2));
        int h1 = a1.hashCode();
        int h2 = a2.hashCode();
        CategoryTextAnnotationTests.assertEquals((int)h1, (int)h2);
    }

    public void testCloning() {
        CategoryTextAnnotation a1 = new CategoryTextAnnotation("Test", (Comparable)((Object)"Category"), 1.0);
        CategoryTextAnnotation a2 = null;
        try {
            a2 = (CategoryTextAnnotation)a1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        CategoryTextAnnotationTests.assertTrue((a1 != a2 ? 1 : 0) != 0);
        CategoryTextAnnotationTests.assertTrue((a1.getClass() == a2.getClass() ? 1 : 0) != 0);
        CategoryTextAnnotationTests.assertTrue((boolean)a1.equals(a2));
    }

    public void testSerialization() {
        CategoryTextAnnotation a1 = new CategoryTextAnnotation("Test", (Comparable)((Object)"Category"), 1.0);
        CategoryTextAnnotation a2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(a1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            a2 = (CategoryTextAnnotation)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        CategoryTextAnnotationTests.assertEquals((Object)a1, a2);
    }
}

