package nativepeer;

/*
 * Copyright (c) 2002-2007 TeamDev Ltd. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * The complete licence text can be found at
 * http://www.teamdev.com/winpack/license.jsf
 */

import com.jniwrapper.win32.automation.types.Variant;
import com.jniwrapper.win32.automation.IDispatch;
import com.jniwrapper.win32.automation.Automation;
import com.jniwrapper.win32.ie.Browser;
import com.jniwrapper.win32.ie.WebBrowser;
import com.jniwrapper.win32.ie.event.DefaultWebBrowserEventsHandler;
import com.jniwrapper.win32.mshtml.IHTMLDocument2;
import com.jniwrapper.win32.mshtml.IHTMLSelectionObject;

import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

/**
 * This sample demonstrates how to empty/clear/get the selected text on the HTML page
 *
 * @author Serge Piletsky
 */
public class SelectionSample {
    public static void main(String[] args) {
        JFrame frame = new JFrame("TestFrame");
        frame.setSize(800, 600);
        frame.setLocationRelativeTo(null);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

        Container contentPane = frame.getContentPane();
        contentPane.setLayout(new BorderLayout());

        final JPanel editAreaPanel = new JPanel();
        editAreaPanel.setLayout(new BorderLayout());

        contentPane.add(editAreaPanel, BorderLayout.CENTER);

        final JPanel browserHolder = new JPanel();
        browserHolder.setLayout(new BorderLayout());

        editAreaPanel.add(browserHolder, BorderLayout.CENTER);

        final Browser browser = new Browser();
        // Navigate to some URL first
        browser.navigate("http://www.teamdev.com");

        browserHolder.add(browser, BorderLayout.CENTER);

        JPanel buttonsPanel = new JPanel();
        JButton clearSelection = new JButton(new AbstractAction("Delete Selection") {
            public void actionPerformed(ActionEvent e) {
                browser.waitReady(); // make sure that the page is loaded
                IHTMLDocument2 documentPeer = (IHTMLDocument2)browser.getDocument().getDocumentPeer();
                IHTMLSelectionObject selection = documentPeer.getSelection();
                if (!selection.isNull()) {
                    selection.clear();
                }
            }
        });

        JButton emptySelection = new JButton(new AbstractAction("Remove Selection") {
            public void actionPerformed(ActionEvent e) {
                browser.waitReady(); // make sure that the page is loaded
                IHTMLDocument2 documentPeer = (IHTMLDocument2)browser.getDocument().getDocumentPeer();
                IHTMLSelectionObject selection = documentPeer.getSelection();
                if (!selection.isNull()) {
                    selection.empty();
                }
            }
        });

        JButton getSelectedText = new JButton(new AbstractAction("Get Selected Text") {
            public void actionPerformed(ActionEvent e) {
                browser.waitReady(); // make sure that the page is loaded
                IHTMLDocument2 documentPeer = (IHTMLDocument2)browser.getDocument().getDocumentPeer();
                final IHTMLSelectionObject selection = documentPeer.getSelection();
                if (!selection.isNull()) {
                    final IDispatch range = selection.createRange();
                    if (!range.isNull()) {
                        browser.getOleMessageLoop().doInvokeLater(new Runnable() {
                            public void run() {
                                Automation automation = new Automation(range);
                                Variant text = automation.getProperty("text");
                                System.out.println("Selected Text = " + text.getValue());
                                Variant htmlText = automation.getProperty("htmlText");
                                System.out.println("Selected HTML = " + htmlText.getValue());
                            }
                        });
                    }
                }
            }
        });

        JButton removeBrowserComponent = new JButton(new AbstractAction("Remove Browser") {
            public void actionPerformed(ActionEvent e) {
                editAreaPanel.removeAll();
            }
        });

        JButton addBrowserComponent = new JButton(new AbstractAction("Add Browser") {
            public void actionPerformed(ActionEvent e) {
                editAreaPanel.add(browserHolder, BorderLayout.CENTER);
            }
        });

        buttonsPanel.setLayout(new FlowLayout(FlowLayout.CENTER));
        buttonsPanel.add(clearSelection);
        buttonsPanel.add(emptySelection);
        buttonsPanel.add(getSelectedText);
        buttonsPanel.add(removeBrowserComponent);
        buttonsPanel.add(addBrowserComponent);

        contentPane.add(buttonsPanel, BorderLayout.SOUTH);

        frame.addWindowListener(new WindowAdapter() {
            public void windowOpened(WindowEvent e) {
                // Make sure that the page is loaded
                browser.waitReady();
                // Setup the blocking handler, which dissalow any further navigations
                browser.setEventHandler(new DefaultWebBrowserEventsHandler() {
                    public boolean beforeNavigate(WebBrowser webBrowser, String url, String targetFrameName, String postData, String headers) {
                        System.out.println("url = " + url);
                        // disable navigating to other URLs
                        return true;
                    }
                });

            }
        });

        frame.setVisible(true);
    }
}
