package nativepeer;

/*
 * Copyright (c) 2002-2007 TeamDev Ltd. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * The complete licence text can be found at
 * http://www.teamdev.com/winpack/license.jsf
 */

import com.jniwrapper.win32.automation.types.BStr;
import com.jniwrapper.win32.ie.HeadlessBrowser;
import com.jniwrapper.win32.ie.WebBrowser;
import com.jniwrapper.win32.ie.dom.HTMLElement;
import com.jniwrapper.win32.ie.dom.HTMLNode;
import com.jniwrapper.win32.mshtml.IHTMLElement;
import com.jniwrapper.win32.mshtml.IHTMLDOMNode;

/**
 * This sample demonstrates technique of working with DOM element native peer.
 *
 * @author Alexei Orischenko
 */
public class ElementPeerSample
{
    public static void main(String[] args) throws Exception
    {
        WebBrowser browser = new HeadlessBrowser();

        browser.setContent("<html><body><div width='400' height='300'>div text</div></body>");
        browser.waitReady();

        HTMLElement element = (HTMLElement)browser.getDocument().getElementsByTagName("div").item(0);
        HTMLNode text = (HTMLNode) element.getFirstChild();

        final IHTMLElement peer = (IHTMLElement)element.getElementPeer();
        final IHTMLDOMNode textPeer = (IHTMLDOMNode) text.getNodePeer();

        browser.getOleMessageLoop().doInvokeAndWait(new Runnable()
        {
            public void run()
            {
                BStr outerHTML = peer.getOuterHTML();
                System.out.println("outerHTML = " + outerHTML);

                Object value = textPeer.getNodeValue().getValue();
                System.out.println("node value = " + value);
            }
        });

        System.exit(0);
    }
}
