package dom;

/*
 * Copyright (c) 2002-2007 TeamDev Ltd. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * The complete licence text can be found at
 * http://www.teamdev.com/winpack/license.jsf
 */

import com.jniwrapper.win32.ie.WebBrowser;
import com.jniwrapper.win32.ie.dom.HTMLElement;
import core.BasicSample;

/**
 * This sample loads Google page and clicks on Groups hyperlink.
 *
 * @author Alexei Orischenko
 */
public class NavigateLinkSample extends BasicSample
{
    public NavigateLinkSample()
    {
        super("Navigate Link");
    }

    protected void execute()
    {
        WebBrowser browser = getBrowser();

        // wait when the browser will be ready to work
        browser.waitReady();

        browser.navigate("http://google.com");
        browser.waitReady();

        HTMLElement groupsLink = (HTMLElement) browser.getDocument().getElementById("2a");

        if (groupsLink != null)
        {
            showMessage("Navigate Groups link");
            groupsLink.click();
        } else
        {
            showMessage("Can't find Groups link.");
        }
    }

    public static void main(String[] args) throws Exception
    {
        new NavigateLinkSample().run();
    }
}
