package dom;

/*
 * Copyright (c) 2002-2007 TeamDev Ltd. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * The complete licence text can be found at
 * http://www.teamdev.com/winpack/license.jsf
 */

import core.BasicSample;
import com.jniwrapper.win32.ie.WebBrowser;
import com.jniwrapper.win32.ie.dom.HTMLElement;
import com.jniwrapper.win32.ie.dom.HTMLDocument;
import org.w3c.dom.Element;

/**
 * This sample shows how to create link in the existing document.
 *
 * @author Alexei Orischenko
 */
public class CreateLinkSample extends BasicSample
{
    public CreateLinkSample()
    {
        super("Link Sample");
    }

    protected void execute()
    {
        final String content = "<html><body>link sample <br> <nobr id='theElem' style='background:#cccccc'>some text </nobr></body></html>";

        WebBrowser browser = getBrowser();
        browser.setContent(content);
        browser.waitReady();

        HTMLDocument document = browser.getDocument();
        HTMLElement element = (HTMLElement) document.getElementById("theElem");

        Element link = document.createElement("a");
        link.setAttribute("className", "fi");
        link.setAttribute("href", "http://www.apple.com");
        link.setAttribute("innerHTML", "www.apple.com");

        element.appendChild(link);
    }

    public static void main(String[] args) throws Exception
    {
        new CreateLinkSample().run();
    }
}
