package core.event;

/*
 * Copyright (c) 2002-2007 TeamDev Ltd. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * The complete licence text can be found at
 * http://www.teamdev.com/winpack/license.jsf
 */

import com.jniwrapper.win32.ie.WebBrowser;
import com.jniwrapper.win32.ie.dom.HTMLDocument;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.Event;
import core.BasicSample;

/**
 * This sample add window scroll event listener.
 *
 * @author Alexei Orischenko
 */
public class WindowEventListenerSample extends BasicSample
{
    public WindowEventListenerSample()
    {
        super("Window Event Listener");
    }

    protected void execute()
    {
        final WebBrowser browser = getBrowser();

        browser.navigate("http://google.com");
        browser.waitReady();

        showMessageSwingLoop("Please resize window and scroll document");

        browser.getDocument().addWindowEventListener("onscroll", new EventListener() {
            public void handleEvent(Event evt)
            {
                System.out.println("Scrolled");
                HTMLDocument document = browser.getDocument();
                int verticalScrollPosition = document.getVerticalScrollPosition();
                System.out.println("verticalScrollPosition = " + verticalScrollPosition);

                int horisontalScrollPosition = document.getHorisontalScrollPosition();
                System.out.println("horisontalScrollPosition = " + horisontalScrollPosition);
            }
        });
    }

    public static void main(String[] args) throws Exception
    {
        new WindowEventListenerSample().run();
    }
}
