package core.event;

/*
 * Copyright (c) 2002-2007 TeamDev Ltd. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * The complete licence text can be found at
 * http://www.teamdev.com/winpack/license.jsf
 */

import com.jniwrapper.win32.ie.WebBrowser;
import com.jniwrapper.win32.ie.event.DefaultWebBrowserEventsHandler;
import com.jniwrapper.win32.ie.event.StatusCode;
import core.BasicSample;

/**
 * This sample demonstrates technique of listenening navigate error events.
 *
 * @author Alexei Orischenko
 */
public class NavigateErrorSample extends BasicSample
{
    public NavigateErrorSample()
    {
        super("Navigation Error");
    }

    protected void execute()
    {
        WebBrowser browser = getBrowser();
        browser.setEventHandler(new DefaultWebBrowserEventsHandler() {
            public boolean navigationErrorOccured(WebBrowser webBrowser, String url, String frame, StatusCode statusCode)
            {
                showMessageSwingLoop("Navigation error: " + statusCode);

                return super.navigationErrorOccured(webBrowser, url, frame, statusCode);
            }
        });


        showMessage("Load unexisiting resource...");
        browser.navigate("http://someexistingsitejniwrpatest.com");
    }

    public static void main(String[] args) throws Exception
    {
        new NavigateErrorSample().run();
    }
}
