package core.event;

/*
 * Copyright (c) 2002-2007 TeamDev Ltd. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * The complete licence text can be found at
 * http://www.teamdev.com/winpack/license.jsf
 */

import com.jniwrapper.win32.ie.event.DefaultWebBrowserEventsHandler;
import com.jniwrapper.win32.ie.WebBrowser;
import core.BasicSample;

/**
 * This sample demonstrates technique of disabling download dialogs that appear on link click.
 *
 * @author Alexei Orischenko
 */
public class DisableDownloadSample extends BasicSample
{
    public DisableDownloadSample()
    {
        super("Disable Download");
    }

    protected void execute()
    {
        WebBrowser browser = getBrowser();

        browser.setEventHandler(new DefaultWebBrowserEventsHandler() {
            public boolean beforeFileDownload()
            {
                // disable downloads
                return true;
            }
        });

        browser.navigate("http://jakarta.apache.org/builds/jakarta-velocity/");
        browser.waitReady();

        showMessage("Disable download dialogs on link click");
    }

    public static void main(String[] args) throws Exception
    {
        new DisableDownloadSample().run();
    }
}
