/*
 * Copyright (c) 2002-2007 TeamDev Ltd. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * The complete licence text can be found at
 * http://www.teamdev.com/winpack/license.jsf
 */
package core;

import com.jniwrapper.win32.ie.Browsers;
import com.jniwrapper.win32.ie.Browser;
import com.jniwrapper.win32.ui.Wnd;
import com.jniwrapper.win32.Rect;
import com.jniwrapper.win32.gdi.WindowDC;
import com.jniwrapper.win32.gdi.DC;
import com.jniwrapper.win32.gdi.Bitmap;
import com.jniwrapper.win32.gdi.DDBitmap;
import com.jniwrapper.win32.ole.IViewObject2;
import com.jniwrapper.win32.ole.types.DvAspect;
import com.jniwrapper.win32.ole.impl.IViewObject2Impl;
import com.jniwrapper.win32.mshtml.IHTMLDocument2;
import com.jniwrapper.Int32;

import javax.swing.*;
import javax.swing.filechooser.FileFilter;
import java.io.File;
import java.awt.*;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

/**
 * @author Ikryanov Vladimir
 */
public class CaptureIEWindowSample extends JFrame
{
    private Browser _browser;

    public CaptureIEWindowSample()
    {
        createBrowser();
        createGUI();
    }

    private void createBrowser()
    {
        _browser = new Browser();
    }

    private void createGUI()
    {
        JButton saveToFile = new JButton("Capture and Save...");
        saveToFile.addActionListener(new ActionListener()
        {
            public void actionPerformed(ActionEvent e)
            {
                JFileChooser fileChooser = new JFileChooser();
                fileChooser.setFileFilter(new FileFilter()
                {
                    public boolean accept(File file)
                    {
                        return file.getName().endsWith(".bmp") || file.isDirectory();
                    }

                    public String getDescription()
                    {
                        return "Bitmap Files (*.bmp)";
                    }
                });
                int returnValue = fileChooser.showSaveDialog(CaptureIEWindowSample.this);
                if (returnValue == JFileChooser.APPROVE_OPTION)
                {
                    String absolutePath = fileChooser.getSelectedFile().getAbsolutePath();
                    saveCaptureToFile(absolutePath);
                    JOptionPane.showMessageDialog(CaptureIEWindowSample.this, "Screen captured and saved as " + absolutePath,
                            "Operation Complete", JOptionPane.INFORMATION_MESSAGE);
                }
            }
        });

        JPanel actionPane = new JPanel();
        actionPane.add(saveToFile);

        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout());
        contentPane.add(_browser, BorderLayout.CENTER);
        contentPane.add(actionPane, BorderLayout.SOUTH);
        setContentPane(contentPane);
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        setTitle("Capture Internet Explorer Window as Image");
        setSize(800, 600);
    }

    public void navigate(String url)
    {
        _browser.navigate(url);
        _browser.waitReady();
    }

    private void saveCaptureToFile(String fileName)
    {
        Wnd wnd = Browsers.getBrowserWindow(_browser);
        Rect windowRect = wnd.getWindowRect();

        int width = windowRect.getWidth();
        int height = windowRect.getHeight();

        IHTMLDocument2 documentPeer = (IHTMLDocument2) _browser.getDocument().getDocumentPeer();
        IViewObject2 viewObject = new IViewObject2Impl(documentPeer);

        if (!viewObject.isNull())
        {
            WindowDC windowDC = new WindowDC(wnd);
            DC hdcCompatible = DC.createCompatibleDC(windowDC);
            final Bitmap imageBitmap = new DDBitmap(windowDC, width, height);
            hdcCompatible.selectObject(imageBitmap);
            Rect lprcBounds = new Rect(new Rectangle(width, height));

            viewObject.draw(
                    new DvAspect(DvAspect.CONTENT),
                    new Int32(-1),
                    null,
                    null,
                    new Int32(windowDC),
                    new Int32(hdcCompatible),
                    lprcBounds,
                    null,
                    new Int32(),
                    new Int32()
            );

            try
            {
                imageBitmap.saveToFile(fileName);
            }
            catch (Exception e)
            {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) throws Exception
    {
        CaptureIEWindowSample capture = new CaptureIEWindowSample();
        capture.setVisible(true);
        capture.setLocationRelativeTo(null);
        capture.navigate("www.google.com");
    }
}
