package core;

/*
 * Copyright (c) 2002-2007 TeamDev Ltd. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * The complete licence text can be found at
 * http://www.teamdev.com/winpack/license.jsf
 */

import com.jniwrapper.win32.ie.BrowserHistory;
import com.jniwrapper.win32.ie.HeadlessBrowser;

import java.util.Iterator;
import java.util.List;

/**
 * This sample demonstrates technique of working with browser history: list of visited pages. 
 *
 * @author Alexei Orischenko
 */
public class BrowserHistorySample
{
    public static void main(String[] args)
    {
        System.out.println("Create browser");

        HeadlessBrowser browser = new HeadlessBrowser();
        System.out.println("Load Google page");
        browser.navigate("http://www.google.com");
        browser.waitReady();

        System.out.println("Load JNIWrapper page");
        browser.navigate("http://www.teamdev.com");
        browser.waitReady();

        BrowserHistory history = new BrowserHistory();
        System.out.println("");
        System.out.println("Browser history:");
        printHistory(history);

        history.clearHistory();

        System.out.println("");
        System.out.println("Browser history after clearing:");
        printHistory(history);

        System.exit(0);
    }

    private static void printHistory(BrowserHistory history)
    {
        List historyEntries = history.getHistory();
        for (Iterator i = historyEntries.iterator(); i.hasNext();)
        {
            BrowserHistory.Entry historyEntry = (BrowserHistory.Entry)i.next();
            System.out.println(historyEntry.getUrl());
        }
    }
}
