/*
 * Copyright (c) 2002-2007 TeamDev Ltd. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * The complete licence text can be found at
 * http://www.teamdev.com/winpack/license.jsf
 */
package com.jniwrapper.win32.ie.samples.demo;

import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

class PopupMenuTracker extends MouseAdapter
{
    private JPopupMenu _popupMenu;

    public PopupMenuTracker(JComponent components[], JPopupMenu popupMenu)
    {
        _popupMenu = popupMenu;
        for (int i = 0; i < components.length; i++)
        {
            JComponent component = components[i];
            component.addMouseListener(this);
        }
    }

    public PopupMenuTracker(JComponent component, JPopupMenu popupMenu)
    {
        this(new JComponent[] {component}, popupMenu);
    }

    public void mouseReleased(MouseEvent e)
    {
        trackPopup(e);
    }

    public void mouseClicked(MouseEvent e)
    {
        trackPopup(e);
    }

    public void mousePressed(MouseEvent e)
    {
        trackPopup(e);
    }

    private void trackPopup(MouseEvent e)
    {
        if (e.isPopupTrigger())
        {
            _popupMenu.show((Component)e.getSource(), e.getX(), e.getY());
        }
    }
}