/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.ie.samples.demo;

import com.jniwrapper.util.Logger;
import com.jniwrapper.win32.ie.Browser;
import com.jniwrapper.win32.ie.ContextMenuProvider;
import com.jniwrapper.win32.ie.WebBrowser;
import com.jniwrapper.win32.ie.event.NavigationEventListener;
import com.jniwrapper.win32.ie.event.NewWindowEventHandler;
import com.jniwrapper.win32.ie.event.StatusEventListener;
import com.jniwrapper.win32.ie.event.WebBrowserEventsHandler;
import com.jniwrapper.win32.ie.samples.demo.BrowserEventsListener;
import com.jniwrapper.win32.ie.samples.demo.BrowserNewWindowEventHandler;
import com.jniwrapper.win32.ie.samples.demo.CommandStateChangeEvent;
import com.jniwrapper.win32.ie.samples.demo.TitledPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.w3c.dom.Element;

class TabbedBrowsersPane
extends TitledPane {
    private static final Logger LOG = Logger.getInstance((Class)(class$com$jniwrapper$win32$ie$samples$demo$TabbedBrowsersPane == null ? (class$com$jniwrapper$win32$ie$samples$demo$TabbedBrowsersPane = TabbedBrowsersPane.class$("com.jniwrapper.win32.ie.samples.demo.TabbedBrowsersPane")) : class$com$jniwrapper$win32$ie$samples$demo$TabbedBrowsersPane));
    public static final String PROPERTY_PROGRESS = "progress";
    public static final String PROPERTY_COMMAND_STATE = "commandState";
    private Map _component2BrowserMap = new HashMap();
    private Map _browserState2BrowserMap = new HashMap();
    private JTabbedPane _tabbedPane = new JTabbedPane();
    private JPopupMenu _actions;
    private JMenuItem _openLinkInNewBrowser;
    static /* synthetic */ Class class$com$jniwrapper$win32$ie$samples$demo$TabbedBrowsersPane;

    public TabbedBrowsersPane(JPopupMenu actions, final Action closeAction) {
        this.setBorder(null);
        this._tabbedPane.setBorder(null);
        this._tabbedPane.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 2) {
                    closeAction.actionPerformed(null);
                }
            }
        });
        this._tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                TabbedBrowsersPane.this.setTitle(TabbedBrowsersPane.this._tabbedPane.getTitleAt(TabbedBrowsersPane.this._tabbedPane.getSelectedIndex()));
                TabbedBrowsersPane.this.updateCommandsState();
            }
        });
        this._tabbedPane.setTabPlacement(3);
        this.setComponent(this._tabbedPane);
        this.assignCloseAction(closeAction);
        this.assignActions(actions);
        this._actions = actions;
        this._openLinkInNewBrowser = new JMenuItem(new OpenLinkInNewTab());
    }

    private void updateCommandsState() {
        WebBrowser activeBrowser = this.getActiveBrowser();
        if (activeBrowser == null) {
            return;
        }
        Boolean[] commandsState = (Boolean[])this._browserState2BrowserMap.get(activeBrowser);
        if (commandsState == null) {
            commandsState = new Boolean[]{Boolean.FALSE, Boolean.FALSE};
        }
        this.fireCommandStateChanged(new CommandStateChangeEvent(activeBrowser, true, commandsState[0]));
        this.fireCommandStateChanged(new CommandStateChangeEvent(activeBrowser, false, commandsState[1]));
    }

    static Font getJapaneseFont() {
        Font[] allFonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        String japaneseSample = "\u4e00";
        for (int i = 0; i < allFonts.length; ++i) {
            if (allFonts[i].canDisplayUpTo(japaneseSample) != -1) continue;
            return new Font(allFonts[i].getName(), 0, 12);
        }
        return null;
    }

    public void addBrowser(final Browser webBrowser) {
        webBrowser.setPreferredSize(new Dimension(100, 100));
        this.setupWebBrowser2EventsHandler((WebBrowser)webBrowser);
        Runnable runnable = new Runnable(){

            public void run() {
                ContextMenuProvider contextMenuProvider = new ContextMenuProvider(this){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public JPopupMenu getPopupMenu(Element contextNode) {
                        boolean isLink = "A".equals(contextNode.getTagName());
                        if (isLink) {
                            TabbedBrowsersPane.access$400(3.access$200(this.this$1)).add(TabbedBrowsersPane.access$300(3.access$200(this.this$1)));
                        } else {
                            TabbedBrowsersPane.access$400(3.access$200(this.this$1)).remove(TabbedBrowsersPane.access$300(3.access$200(this.this$1)));
                        }
                        return TabbedBrowsersPane.access$400(3.access$200(this.this$1));
                    }
                };
                webBrowser.setContextMenuProvider(contextMenuProvider);
                TabbedBrowsersPane.this._tabbedPane.addTab(null, (Component)webBrowser);
                TabbedBrowsersPane.this._tabbedPane.setSelectedComponent((Component)webBrowser);
                Font font = TabbedBrowsersPane.getJapaneseFont();
                if (font != null) {
                    TabbedBrowsersPane.this._tabbedPane.setFont(font);
                }
            }

            static /* synthetic */ TabbedBrowsersPane access$200(3 x0) {
                return x0.TabbedBrowsersPane.this;
            }
        };
        SwingUtilities.invokeLater(runnable);
        this._component2BrowserMap.put(webBrowser, webBrowser);
    }

    public WebBrowser createBrowser() {
        Browser webBrowser = new Browser();
        this.addBrowser(webBrowser);
        return webBrowser;
    }

    int getBrowserIndex(WebBrowser webBrowser) {
        return this._tabbedPane.indexOfComponent((Component)webBrowser);
    }

    public void updateBrowserTitle(WebBrowser webBrowser, String title) {
        int index = this.getBrowserIndex(webBrowser);
        this._tabbedPane.setTitleAt(index, title);
        this._tabbedPane.setToolTipTextAt(index, title);
        this.setTitle(title);
    }

    public void removeBrowser(final WebBrowser webBrowser) {
        final int index = this.setActiveBrowser(webBrowser);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TabbedBrowsersPane.this._tabbedPane.remove(index);
                if (index == 0) {
                    TabbedBrowsersPane.this._tabbedPane.setSelectedIndex(index);
                }
                webBrowser.close();
                TabbedBrowsersPane.this._component2BrowserMap.remove(webBrowser);
                TabbedBrowsersPane.this.updateCommandsState();
            }
        });
    }

    void removeBrowser() {
        final WebBrowser browser = this.getActiveBrowser();
        if (this._tabbedPane.getTabCount() > 1) {
            this.setActiveBrowser(browser);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (TabbedBrowsersPane.this._tabbedPane.getTabCount() > 1) {
                    TabbedBrowsersPane.this.removeBrowser(browser);
                }
            }
        });
    }

    private int setActiveBrowser(WebBrowser webBrowser) {
        int index = this.getBrowserIndex(webBrowser);
        int newIndex = index == this._tabbedPane.getTabCount() - 1 ? index - 1 : index + 1;
        this._tabbedPane.setSelectedIndex(newIndex);
        return index;
    }

    public WebBrowser getActiveBrowser() {
        Component selectedComponent = this._tabbedPane.getSelectedComponent();
        return (WebBrowser)this._component2BrowserMap.get(selectedComponent);
    }

    private void setupWebBrowser2EventsHandler(WebBrowser browser) {
        BrowserEventsListener eventHandler = new BrowserEventsListener();
        browser.addNavigationListener((NavigationEventListener)eventHandler);
        browser.addStatusListener((StatusEventListener)eventHandler);
        browser.setEventHandler((WebBrowserEventsHandler)eventHandler);
        eventHandler._tabbedBrowsersPane = this;
        eventHandler._webBrowser = browser;
        BrowserNewWindowEventHandler handler = new BrowserNewWindowEventHandler(browser);
        handler._tabbedBrowsersPane = this;
        browser.setNewWindowHandler((NewWindowEventHandler)handler);
    }

    public JTabbedPane getTabbedPane() {
        return this._tabbedPane;
    }

    private void updateButtonState(WebBrowser browser, boolean isBackButton, boolean enable) {
        Boolean[] commandsState = (Boolean[])this._browserState2BrowserMap.get(browser);
        if (commandsState == null) {
            commandsState = new Boolean[]{Boolean.FALSE, Boolean.FALSE};
            this._browserState2BrowserMap.put(browser, commandsState);
        }
        int index = isBackButton ? 0 : 1;
        commandsState[index] = new Boolean(enable);
        this.fireCommandStateChanged(new CommandStateChangeEvent(browser, isBackButton, enable));
    }

    public void backButtonEnabled(WebBrowser browser, boolean enabled) {
        this.updateButtonState(browser, true, enabled);
    }

    public void forwardButtonEnabled(WebBrowser browser, boolean enabled) {
        this.updateButtonState(browser, false, enabled);
    }

    public void progressChanged(int progress, int progressMax) {
        this.firePropertyChange(PROPERTY_PROGRESS, new Integer(progress), new Integer(progressMax));
    }

    protected void fireCommandStateChanged(CommandStateChangeEvent event) {
        this.firePropertyChange(PROPERTY_COMMAND_STATE, null, event);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ JMenuItem access$300(TabbedBrowsersPane x0) {
        return x0._openLinkInNewBrowser;
    }

    static /* synthetic */ JPopupMenu access$400(TabbedBrowsersPane x0) {
        return x0._actions;
    }

    private class OpenLinkInNewTab
    extends AbstractAction {
        public OpenLinkInNewTab() {
            super("Open Link in New Tab");
        }

        public void actionPerformed(ActionEvent e) {
            WebBrowser webBrowser = TabbedBrowsersPane.this.getActiveBrowser();
            if (!(webBrowser instanceof Browser)) {
                return;
            }
            Element element = ((Browser)webBrowser).getContextElement();
            if (element == null) {
                return;
            }
            if ("A".equalsIgnoreCase(element.getNodeName())) {
                WebBrowser browser = TabbedBrowsersPane.this.createBrowser();
                String url = element.getAttribute("href");
                browser.navigate(url);
            }
        }
    }
}

