/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.jexcel.samples.demo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

class TitledPane
extends JPanel {
    private long _hideTime = System.currentTimeMillis();
    private static final long HIDE_INTERVAL = 300L;
    protected JLabel _title;
    protected JLabel _menuIcon;
    protected JLabel _closeIcon;

    public TitledPane() {
        this.setLayout(new BorderLayout());
        JPanel titlePanel = new JPanel();
        titlePanel.setLayout(new GridBagLayout());
        titlePanel.setBorder(null);
        this._closeIcon = new JLabel();
        Cursor handCursor = new Cursor(12);
        this._closeIcon.setCursor(handCursor);
        this._closeIcon.setIcon(new ImageIcon(this.getClass().getResource("res/Close.gif")));
        this._closeIcon.setToolTipText("Close");
        final Border emptyBorder = BorderFactory.createEmptyBorder(1, 2, 1, 2);
        final Border etchedBorder = BorderFactory.createEtchedBorder();
        this._closeIcon.setBorder(emptyBorder);
        this._closeIcon.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                TitledPane.this._closeIcon.setBorder(etchedBorder);
            }

            public void mouseExited(MouseEvent e) {
                TitledPane.this._closeIcon.setBorder(emptyBorder);
            }
        });
        this._menuIcon = new JLabel();
        this._menuIcon.setCursor(handCursor);
        this._menuIcon.setIcon(new ImageIcon(this.getClass().getResource("res/downArrow.gif")));
        this._menuIcon.setToolTipText("Menu");
        this._menuIcon.setBorder(emptyBorder);
        this._menuIcon.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                TitledPane.this._menuIcon.setBorder(etchedBorder);
            }

            public void mouseExited(MouseEvent e) {
                TitledPane.this._menuIcon.setBorder(emptyBorder);
            }
        });
        this._title = new JLabel("");
        this._title.setFocusable(false);
        this._title.setBorder(null);
        Font oldFont = this._title.getFont();
        Font newFont = new Font("Tahoma", 1, oldFont.getSize());
        this._title.setFont(newFont);
        titlePanel.add((Component)this._title, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        titlePanel.add((Component)this._menuIcon, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        titlePanel.add((Component)this._closeIcon, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        titlePanel.add((Component)new LineBevel(), new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)titlePanel, "North");
    }

    public TitledPane(String name, JComponent content, JPopupMenu actions, Action closeAction) {
        this();
        this.setTitle(name);
        this.setComponent(content);
        if (actions != null) {
            this.assignActions(actions);
        }
        if (closeAction != null) {
            this.assignCloseAction(closeAction);
        }
    }

    public void setTitle(String value) {
        this._title.setText(value);
    }

    public void setComponent(JComponent component) {
        this.add((Component)component, "Center");
    }

    public void assignActions(final JPopupMenu actions) {
        this._menuIcon.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (System.currentTimeMillis() - TitledPane.this._hideTime < 300L) {
                    return;
                }
                actions.show(TitledPane.this._menuIcon, 0, TitledPane.this._menuIcon.getHeight());
            }
        });
        actions.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                TitledPane.this._hideTime = System.currentTimeMillis();
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }
        });
    }

    public void assignCloseAction(final Action closeAction) {
        this._closeIcon.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                closeAction.actionPerformed(null);
            }
        });
    }

    private static class LineBevel
    extends JPanel {
        public LineBevel(int type) {
            this.init(type);
        }

        private void init(int type) {
            this.setBorder(new LineBorder(type));
            if (type == 0) {
                this.setPreferredSize(new Dimension(1, 2));
            } else {
                this.setPreferredSize(new Dimension(2, 1));
            }
        }

        public LineBevel() {
            this.init(0);
        }
    }

    private static class LineBorder
    extends AbstractBorder {
        public static final int HORISONTAL = 0;
        public static final int VERTICAL = 1;
        private int _type = 0;

        public LineBorder() {
        }

        public LineBorder(int type) {
            this._type = type;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.translate(x, y);
            if (this._type == 0) {
                int w = width;
                int h = height - 1;
                g.setColor(Color.lightGray);
                g.drawLine(0, h - 1, w - 1, h - 1);
                g.setColor(Color.white);
                g.drawLine(1, h, w, h);
            } else if (this._type == 1) {
                int h = height;
                g.setColor(Color.lightGray);
                g.drawLine(0, 0, 0, h - 1);
                g.setColor(Color.white);
                g.drawLine(1, 1, 1, h);
            }
            g.translate(-x, -y);
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(0, 0, 0, 0);
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }
}

