unit demomain;

interface

uses
  SysUtils, Windows, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls, Menus, ComCtrls;

type
  TMainForm = class(TForm)
    MainMenu: TMainMenu;
    FileExitItem: TMenuItem;
    StatusLine: TStatusBar;
    perlPattern: TMemo;
    Splitter1: TSplitter;
    Panel1: TPanel;
    parseButton: TButton;
    easyPattern: TMemo;
    N1: TMenuItem;
    Parse1: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure ShowHint(Sender: TObject);
    procedure FileExit(Sender: TObject);
    procedure parseButtonClick(Sender: TObject);

  protected
    epapp : variant;
    ep : variant;
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

uses comobj;


procedure TMainForm.FormCreate(Sender: TObject);
begin
  Application.OnHint := ShowHint;
  try
    epapp := createOLEObject( 'EPEngine.Application' );
    ep := epapp.new;
  except on e:exception do
    raise exception.create( 'Can''t create EPEngine.Application - has it been registered?' );
  end;
end;

procedure TMainForm.ShowHint(Sender: TObject);
begin
  StatusLine.SimpleText := Application.Hint;
end;

procedure TMainForm.FileExit(Sender: TObject);
begin
  Close;
end;

procedure TMainForm.parseButtonClick(Sender: TObject);

var s,e : string;

begin
  s := easyPattern.lines.text;
  s := ep.EasyPattern2Perl( s );
  e := ep.LastError;
  if e <> '' then
    perlPattern.lines.text := e
  else
    perlPattern.lines.text := s;
end;

end.
