header
{
package com.jniwrapper.generator.c.parser;
}

{
import java.util.List;
import java.util.LinkedList;
}

class CParser extends Parser;

options
{
	k = 3;
	buildAST = true;
	ASTLabelType = "CNode";
	defaultErrorHandler = true;
}
{
    private String _fileName = "";
    private List _errorList = new LinkedList();

    public void setFileName(String fileName)
    {
        _fileName = fileName;
    }

    public void clearErrorList()
    {
        _errorList.clear();
    }

    public List getErrorList()
    {
        return _errorList;
    }

    public void reportError(RecognitionException ex)
    {
        if (ex instanceof NoViableAltException)
        {
            CToken token = (CToken) ((NoViableAltException) ex).token;
            _errorList.add(new ParserErrorMessage(_fileName, ex.line, ex.column, ex.getMessage(), token.getSourceLine()));
        }
        else
        {
            _errorList.add(new ParserErrorMessage(_fileName, ex.line, ex.column, ex.getMessage()));
        }
    }
}

externalDeclaration
	:	
	(	SEMI
	|   strucuresOrUnionsOrEnums
	|	typedefDeclaration
	|	(externModifier) => staticVarOrFunction
	|   varOrFunction
	|   unexpectedToken
	)*
	;

unexpectedToken: ID { throw new NoViableAltException(LT(0), getFilename()); } ;

strucuresOrUnionsOrEnums
	:	structureDefination
	|	unionDefination
	|	enumDefination
	;

//-------------------------------------------------------------------------------------------------

varsBlock: (LCURLY! instanceVariables RCURLY!)? { #varsBlock = #(#[LCURLY, "varsBlock"], varsBlock); } ;

instanceVariables: (instanceVariable)* ;

structureDefination
	:	(KEYWORD_STRUCT LCURLY) => KEYWORD_STRUCT^ varsBlock (varList)? SEMI!
	|	KEYWORD_STRUCT^ ID varsBlock (varList)? SEMI!
	;

varList: varName (COMMA! varName)* ;

varName: pointerGroup ID (arrayDeclaration)? ;

unionDefination
	:	(KEYWORD_UNION LCURLY) => KEYWORD_UNION^ varsBlock (varList)? SEMI!
	|	KEYWORD_UNION^ ID varsBlock (varList)? SEMI!
	;

enumDefination
	:	(KEYWORD_ENUM LCURLY) => KEYWORD_ENUM^ enumBlock (varList)? SEMI!
	|	(KEYWORD_ENUM ID LCURLY) => KEYWORD_ENUM^ ID enumBlock (varList)? SEMI!
	|	KEYWORD_ENUM^ ID (varList)? SEMI!
	;

enumBlock: LCURLY^ enumValueList RCURLY! ;

enumValueList: (enumValueName (COMMA!)? )* ;

enumValueName: ID^ (ASSIGN! enumValueExpr)? ;

enumValueExpr: expr ;

//-------------------------------------------------------------------------------------------------

instanceVariable
	:	(complexType LPAREN) => functionVariable SEMI! 
	|	(typeQualifier KEYWORD_STRUCT) => typeQualifier! strucuresOrUnionsOrEnums
	        { #instanceVariable = #(#[LCURLY, "variable"], instanceVariable); }
	|	(strucuresOrUnionsOrEnums | complexType variableName (COMMA! pointerGroup variableName)* SEMI!) 
	        { #instanceVariable = #(#[LCURLY, "variable"], instanceVariable); }
	;

variableName: bitModifier | (typeQualifier!)? ID^ (arrayDeclaration)? (bitModifier)? ;

arrayDeclaration: LBRACKET^ (expr)? RBRACKET! ;

bitModifier: COLON^ expr ;

complexType
    :   (typeQualifier!)?
        (KEYWORD_STRUCT! | KEYWORD_ENUM!)?
        ("__w64"!)? aType ("__w64"!)? pointerGroup { #complexType = #(#[LCURLY, "complexType"], complexType); } ;

aType: (typeQualifier!)? modifier (typeSpecifier)* | (typeQualifier!)? (typeSpecifier)+ | ID (LT! ID GT!)? ;

pointerGroup: (STAR (typeQualifier!)?)* ;

functionVariable: complexType LPAREN! (STAR)* ID^ RPAREN! functionParameters 
	{ #functionVariable = #(#[LCURLY, "callback"], functionVariable); }
	;

//-------------------------------------------------------------------------------------------------

staticVarOrFunction
	: 	(externModifier (functionQualifier)? complexType (functionQualifier)? ID LPAREN) => externFunctionDeclaration
	|	staticVarDeclaration;

externModifier: "extern" ;

staticVarDeclaration: externModifier instanceVariable { #staticVarDeclaration = #(#[COLON, "static"], #staticVarDeclaration); } ;

externFunctionDeclaration: externModifier (functionQualifier)? functionReturnType (functionQualifier)? ID functionParameters SEMI!
                                { #externFunctionDeclaration = #(#[COLON, "externFunction"], #externFunctionDeclaration); } ;

functionReturnType: complexType { #functionReturnType = #(#[COLON, "returnType"], #functionReturnType); } ;

functionParameters: LPAREN! (functionParameter)? (COMMA! (functionParameter | ELLIPSIS))* RPAREN! ;

functionParameter
	:	(complexType LPAREN) => complexType LPAREN! (STAR)* (ID)? RPAREN! functionParameters
	|	complexType functionParameterName (arrayDeclaration)?
	{ #functionParameter = #(#[COLON, "parameter"], #functionParameter); }
	;

functionParameterName: ID | { #functionParameterName = #(#[COLON, "-*-"], #functionParameterName); } ;

//-------------------------------------------------------------------------------------------------

varOrFunction
	: 	((functionQualifier)? complexType (functionQualifier)? ID LPAREN) => functionDeclaration
	|	varDeclaration;

varDeclaration: instanceVariable { #varDeclaration = #(#[COLON, "dynamic"], #varDeclaration); } ;

functionDeclaration: (functionQualifier)? functionReturnType (functionQualifier)? ID functionParameters SEMI!
                        { #functionDeclaration = #(#[COLON, "function"], #functionDeclaration); } ;

//-------------------------------------------------------------------------------------------------

typedefDeclaration:  KEYWORD_TYPEDEF^ instanceVariable ;

//-------------------------------------------------------------------------------------------------

modifier: "signed" | "unsigned" ;

typeSpecifier
	:	"void"
	|	"char"
	|	"short"
	|	"int"
	|	"long"
	|	"float"
	|	"double"
	|   "__int8"
	|   "__int16"
	|   "__int32"
	|   "__int64"
	;

typeQualifier
	:	"const"
	|	"volatile"
	;

functionQualifier
    :   "stdcall"
    |   "cdecl"
    |   "__cdecl"
    |   "__fastcall"
    |   "__stdcall"
    ;

//-------------------------------------------------------------------------------------------------

expr: assignExpr ;

assignExpr
        :       conditionalExpr ( a:assignOperator! assignExpr { ## = #( #a, ## );} )?
        ;

assignOperator
        :       ASSIGN
        |       DIV_ASSIGN
        |       PLUS_ASSIGN
        |       MINUS_ASSIGN
        |       STAR_ASSIGN
        |       MOD_ASSIGN
        |       RSHIFT_ASSIGN
        |       LSHIFT_ASSIGN
        |       BAND_ASSIGN
        |       BOR_ASSIGN
        |       BXOR_ASSIGN
        ;

conditionalExpr
        :       logicalOrExpr
                ( QUESTION^ expr COLON! conditionalExpr )?
        ;

constExpr
        :       conditionalExpr
        ;

logicalOrExpr
        :       logicalAndExpr ( LOR^ logicalAndExpr )*
        ;

logicalAndExpr
        :       inclusiveOrExpr ( LAND^ inclusiveOrExpr )*
        ;

inclusiveOrExpr
        :       exclusiveOrExpr ( BOR^ exclusiveOrExpr )*
        ;

exclusiveOrExpr
        :       bitAndExpr ( BXOR^ bitAndExpr )*
        ;

bitAndExpr
        :       equalityExpr ( BAND^ equalityExpr )*
        ;

equalityExpr
        :       relationalExpr
                ( ( EQUAL^ | NOT_EQUAL^ ) relationalExpr )*
        ;

relationalExpr
        :       shiftExpr
                ( ( LT^ | LTE^ | GT^ | GTE^ ) shiftExpr )*
        ;

shiftExpr
        :       additiveExpr
                ( ( LSHIFT^ | RSHIFT^ ) additiveExpr )*
        ;

additiveExpr
        :       multExpr
                ( ( PLUS^ | MINUS^ ) multExpr )*
        ;

multExpr
        :       castExpr
                ( ( STAR^ | DIV^ | MOD^ ) castExpr )*
        ;

castExpr
        :       ( LPAREN typeName RPAREN )=>
                LPAREN! typeName RPAREN! ( castExpr )
                            { ## = #( #[NCast, "("], ## ); }
        |       unaryExpr
        ;

typeName: ID ;

unaryExpr
        :       postfixExpr
        |       INC^ unaryExpr
        |       DEC^ unaryExpr
        |       u:unaryOperator castExpr { ## = #( #[NUnaryExpr], ## ); }
        |       "sizeof"^
                ( ( LPAREN typeName )=> LPAREN typeName RPAREN
                | unaryExpr
                )
        ;

unaryOperator
        :       BAND
        |       STAR
        |       PLUS
        |       MINUS
        |       BNOT
        |       LNOT
        ;

postfixExpr
        :       primaryExpr
                ( 
                postfixSuffix                   {## = #( #[NPostfixExpr], ## );} 
                )?
        ;

postfixSuffix
        :
                ( PTR ID
                | DOT ID
                | LBRACKET expr RBRACKET
                | INC
                | DEC
                )+
        ;

primaryExpr
        :       ID
        |       charConst
        |       intConst
        |       floatConst
        |       stringConst
        |       LPAREN! expr RPAREN!        { ## = #( #[NExpressionGroup, "("], ## ); }
        ;

protected
charConst
        :       CharLiteral
        ;

protected
stringConst
        :       (StringLiteral)+                { ## = #(#[NStringSeq], ##); }
        ;

protected
intConst
        :       IntOctalConst
        |       LongOctalConst
        |       UnsignedOctalConst
        |       IntIntConst
        |       LongIntConst
        |       UnsignedIntConst
        |       IntHexConst
        |       LongHexConst
        |       UnsignedHexConst
        ;

protected
floatConst
        :       FloatDoubleConst
        |       DoubleDoubleConst
        |       LongDoubleConst
        ;

dummy
        :       NCast
	|	NExpressionGroup
        |       NUnaryExpr
        |       NPostfixExpr
        |       NStringSeq
        ;

//-------------------------------------------------------------------------------------------------

{
import antlr.*;

import java.util.List;
import java.util.LinkedList;
}

class CLexer extends Lexer;

options
{
        k = 3;
        testLiterals = false;
}

tokens
{
	KEYWORD_STRUCT		    = "struct";
	KEYWORD_UNION		    = "union";
	KEYWORD_ENUM		    = "enum";
	KEYWORD_TYPEDEF		    = "typedef";

	PREPROCESSOR_INCLUDE	= "#include";
	PREPROCESSOR_IMPORT	    = "#import";
	PREPROCESSOR_DEFINE	    = "#define";
	PREPROCESSOR_IF		    = "#if";
	PREPROCESSOR_IFDEF	    = "#ifdef";
	PREPROCESSOR_ELSE	    = "#else";
	PREPROCESSOR_ELIF	    = "#elif";
	PREPROCESSOR_ENDIF	    = "#endif";
	PREPROCESSOR_LINE	    = "#line";
	PREPROCESSOR_WARNING	= "#warning";
}

{
    private String[] _source;
    private String _fileName = "";
    private List _errorList = new LinkedList();
    private int _lineCount = 1;
    private int _deferredLineCount = 0;

    public void setSource(String source)
    {
        _source = source.split("\n");
    }

    public void setFileName(String fileName)
    {
        _fileName = fileName;
    }

    public void clearErrorList()
    {
        _errorList.clear();
    }

    public List getErrorList()
    {
        return _errorList;
    }

    public void reportError(RecognitionException ex)
    {
         _errorList.add(new ParserErrorMessage(_fileName, ex.line, ex.column, ex.getMessage()));
    }

    protected Token makeToken(int token)
    {
        super.setTokenObjectClass("com.jniwrapper.generator.c.parser.CToken");
        CToken newToken = (CToken) super.makeToken(token);

        _lineCount += _deferredLineCount;
        _deferredLineCount = 0;
        newToken.setLine(_lineCount);
        if (_lineCount - 1 < _source.length)
        {
            newToken.setSourceLine(_source[_lineCount - 1]);
        }

        return newToken;
    }

    public void deferredNewline()
    {
        _deferredLineCount++;
    }

    public void newline()
    {
        _lineCount++;
    }

}

protected
Vocabulary
        :       '\3'..'\377'
        ;

ASSIGN          : '=' ;
COLON           : ':' ;
COMMA           : ',' ;
QUESTION        : '?' ;
SEMI            : ';' ;

LPAREN          : '(' ;
RPAREN          : ')' ;
LBRACKET        : '[' ;
RBRACKET        : ']' ;
LCURLY          : '{' ;
RCURLY          : '}' ;

ELLIPSIS        : "...";

EQUAL           : "==" ;
NOT_EQUAL       : "!=" ;
LTE             : "<=" ;
LT              : "<" ;
GTE             : ">=" ;
GT              : ">" ;

DIV             : '/' ;
PLUS            : '+' ;
MINUS           : '-' ;
STAR            : '*' ;
MOD             : '%' ;
RSHIFT          : ">>" ;
LSHIFT          : "<<" ;

LAND            : "&&" ;
LNOT            : '!' ;
LOR             : "||" ;

BAND            : '&' ;
BNOT            : '~' ;
BOR             : '|' ;
BXOR            : '^' ;

protected
VARARGS:;

Whitespace
        :       ( ( '\003'..'\010' | '\t' | '\013' | '\f' | '\016'.. '\037' | '\177'..'\377' | ' ' )
                | "\r\n"                { newline(); }
                | ( '\n' | '\r' )       { newline(); }
                )                       { _ttype = Token.SKIP;  }
        ;

Comment
        :       "/*"
                ( { LA(2) != '/' }? '*'
                | "\r\n"                { deferredNewline(); }
                | ( '\r' | '\n' )       { deferredNewline(); }
                | ~( '*'| '\r' | '\n' )
                )*
                "*/"                    { _ttype = Token.SKIP; }
        ;


CPPComment
        :
                "//" ( ~('\n') )* 	{ _ttype = Token.SKIP; }
        ;

/* Literals: */

/*
 * Note that we do NOT handle tri-graphs nor multi-byte sequences.
 */


/*
 * Note that we can't have empty character constants (even though we
 * can have empty strings :-).
 */

CharLiteral
        :       '\'' ( Escape | ~( '\'' ) )* '\''
        ;

/*
 * Can't have raw imbedded newlines in string constants.  Strict reading of
 * the standard gives odd dichotomy between newlines & carriage returns.
 * Go figure.
 */

StringLiteral
        :       '"'
                ( Escape
                | ( 
                    '\r'        { deferredNewline(); }
                  | '\n'        {
                                    deferredNewline();
                                    _ttype = BadStringLiteral;
                                }
                  | '\\' '\n'   { deferredNewline(); }
                  )
                | ~( '"' | '\r' | '\n' | '\\' )
                )*
                '"'
        ;

protected BadStringLiteral
        :       // Imaginary token.
        ;

/*
 * Handle the various escape sequences.
 *
 * Note carefully that these numeric escape *sequences* are *not* of the
 * same form as the C language numeric *constants*.
 *
 * There is no such thing as a binary numeric escape sequence.
 *
 * Octal escape sequences are either 1, 2, or 3 octal digits exactly.
 *
 * There is no such thing as a decimal escape sequence.
 *
 * Hexadecimal escape sequences are begun with a leading \x and continue
 * until a non-hexadecimal character is found.
 *
 * No real handling of tri-graph sequences, yet.
 */

protected
Escape  
        :       '\\'
                ( options{warnWhenFollowAmbig=false;}:
                  'a'
                | 'b'
                | 'f'
                | 'n'
                | 'r'
                | 't'
                | 'v'
                | '"'
                | '\''
                | '\\'
                | '?'
                | ('0'..'3') ( options{warnWhenFollowAmbig=false;}: Digit ( options{warnWhenFollowAmbig=false;}: Digit )? )?
                | ('4'..'7') ( options{warnWhenFollowAmbig=false;}: Digit )?
                | 'x' ( options{warnWhenFollowAmbig=false;}: Digit | 'a'..'f' | 'A'..'F' )+
                )
        ;

protected Space
        :       ( ' ' | '\t' | '\014')
        ;

/* Numeric Constants: */

protected
Digit
        :       '0'..'9'
        ;

protected
LongSuffix
        :       'l'
        |       'L'
        ;

protected
UnsignedSuffix
        :       'u'
        |       'U'
        ;

protected
FloatSuffix
        :       'f'
        |       'F'
        ;

protected
Exponent
        :       ( 'e' | 'E' ) ( '+' | '-' )? ( Digit )+
        ;


protected
DoubleDoubleConst:;

protected
FloatDoubleConst:;

protected
LongDoubleConst:;

protected
IntOctalConst:;

protected
LongOctalConst:;

protected
UnsignedOctalConst:;

protected
IntIntConst:;

protected
LongIntConst:;

protected
UnsignedIntConst:;

protected
IntHexConst:;

protected
LongHexConst:;

protected
UnsignedHexConst:;

Number
        :       ( ( Digit )+ ( '.' | 'e' | 'E' ) )=> ( Digit )+
                ( '.' ( Digit )* ( Exponent )?
                | Exponent
                )                       { _ttype = DoubleDoubleConst;   }
                ( FloatSuffix           { _ttype = FloatDoubleConst;    }
                | LongSuffix            { _ttype = LongDoubleConst;     }
                )?

        |       ( "..." )=> "..."       { _ttype = VARARGS;     }

        |       '.'                     { _ttype = DOT; }
                ( ( Digit )+ ( Exponent )?
                                        { _ttype = DoubleDoubleConst;   }
                  ( FloatSuffix         { _ttype = FloatDoubleConst;    }
                  | LongSuffix          { _ttype = LongDoubleConst;     }
                  )?
                )?

        |       '0' ( '0'..'7' )*       { _ttype = IntOctalConst;       }
                ( LongSuffix            { _ttype = LongOctalConst;      }
                | UnsignedSuffix        { _ttype = UnsignedOctalConst;  }
                )?

        |       '1'..'9' ( Digit )*     { _ttype = IntIntConst;         }
                ( LongSuffix            { _ttype = LongIntConst;        }
                | UnsignedSuffix        { _ttype = UnsignedIntConst;    }
                )?

        |       '0' ( 'x' | 'X' ) ( 'a'..'f' | 'A'..'F' | Digit )+
                                        { _ttype = IntHexConst;         }
                ( LongSuffix            { _ttype = LongHexConst;        }
                | UnsignedSuffix        { _ttype = UnsignedHexConst;    }
                )?
        ;

ID
        options
	{
                testLiterals = true; 
	}
        :       ( 'a'..'z' | 'A'..'Z' | '_' )
                ( 'a'..'z' | 'A'..'Z' | '_' | '0'..'9' )*
        ;

PREPROCESSOR
        :       '#'
        (       '\\' (' ' | '\t')* ('\r' | '\n') { deferredNewline(); }
        |       Comment
        |       ~('\r' | '\n')                   { deferredNewline(); }
        )*
        {
                _ttype = Token.SKIP;
        }
        ;
