/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper;

import com.jniwrapper.DelegatingParameter;
import com.jniwrapper.Int16;
import com.jniwrapper.Int32;
import com.jniwrapper.Int64;
import com.jniwrapper.Int8;
import com.jniwrapper.IntegerParameter;
import com.jniwrapper.Parameter;
import com.jniwrapper.PlatformContext;

public class Bool
extends DelegatingParameter {
    public static final Bool FALSE = new Bool(false);
    public static final Bool TRUE = new Bool(true);

    public Bool() {
        super(Bool.b());
    }

    public Bool(boolean bl) {
        this();
        this.setValue(bl);
    }

    public Bool(Bool bool) {
        this();
        this.setValue(bool.getValue());
    }

    public Boolean toBoolean() {
        return new Boolean(this.getValue());
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Bool) {
            return this.getValue() == ((Bool)object).getValue();
        }
        if (object instanceof IntegerParameter) {
            return this.getValue() == (((IntegerParameter)object).getValue() != 0L);
        }
        return super.equals(object);
    }

    public int hashCode() {
        return this.getValueObject().hashCode();
    }

    public String getDebugInfo() {
        return this.getClass().getName() + " value: " + String.valueOf(this.getValue());
    }

    public String toString() {
        return Boolean.toString(this.getValue());
    }

    public void setValue(boolean bl) {
        IntegerParameter integerParameter = (IntegerParameter)((Object)this.getValueObject());
        integerParameter.setValue(bl ? 1L : 0L);
    }

    public boolean getValue() {
        IntegerParameter integerParameter = (IntegerParameter)((Object)this.getValueObject());
        return integerParameter.getValue() != 0L;
    }

    public Object clone() {
        return new Bool(this);
    }

    private static Parameter b() {
        int n2 = PlatformContext.getBoolLength();
        switch (n2) {
            case 1: {
                return new Int8();
            }
            case 2: {
                return new Int16();
            }
            case 4: {
                return new Int32();
            }
            case 8: {
                return new Int64();
            }
        }
        throw new RuntimeException("Invalid size of boolean type");
    }
}

