/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.samples.demo;

import com.jniwrapper.win32.automation.OleContainer;
import com.jniwrapper.win32.com.ComException;
import com.jniwrapper.win32.com.types.CLSID;
import com.jniwrapper.win32.shell.SHFileInfo;
import java.io.File;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public abstract class OleContainerInfoBean {
    protected String _className;
    protected String _extentions;
    protected String _defaultAssociation;
    protected String _description;
    protected OleContainer _container;
    protected ImageIcon _associatedIcon;
    private boolean _installed;

    public OleContainerInfoBean(String className, String extentions, String description, String defaultAssociation) {
        this._className = className;
        this._extentions = extentions;
        this._description = description;
        this._defaultAssociation = defaultAssociation;
        try {
            CLSID.createFromProgID((String)className);
            this._installed = true;
        }
        catch (ComException e) {
            if (e.getHResult() == -2147221005) {
                this._installed = false;
            }
            throw e;
        }
    }

    public boolean isInstalled() {
        return this._installed;
    }

    public String getClassName() {
        return this._className;
    }

    public String getExtentions() {
        return this._extentions;
    }

    public String getDescription() {
        return this._description;
    }

    public OleContainer getContainer() {
        if (this._container == null && this.isInstalled()) {
            this._container = new OleContainer();
            try {
                this._container.createObject(this._className);
            }
            catch (ComException comException) {
                // empty catch block
            }
        }
        return this._container;
    }

    public abstract void loadFile(String var1);

    public JPanel createFileInfoPanel() {
        return null;
    }

    public void activate() {
        if (this.isInstalled()) {
            OleContainer container = this.getContainer();
            container.doVerb(-1);
        }
    }

    public void destroy() {
        if (this.isInstalled()) {
            this.getContainer().destroyObject();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageIcon getIcon() {
        if (this._associatedIcon == null) {
            try {
                File temporaryEmptyFile = new File("temp." + this._defaultAssociation);
                try {
                    temporaryEmptyFile.createNewFile();
                    this._associatedIcon = new ImageIcon(SHFileInfo.getFileInfo((String)temporaryEmptyFile.getAbsolutePath(), (int)257).getIcon().toImage());
                }
                finally {
                    temporaryEmptyFile.delete();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this._associatedIcon;
    }
}

