/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.samples.shell.components;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.text.MessageFormat;
import javax.swing.Icon;
import javax.swing.JLabel;

public class HTMLText
extends JLabel {
    private String _htmlTextPattern;
    private boolean _antialiasedText = true;

    public HTMLText(String text, Icon icon, int horizontalAlignment) {
        super(text, icon, horizontalAlignment);
    }

    public HTMLText(String text, int horizontalAlignment) {
        super(text, horizontalAlignment);
    }

    public HTMLText(String text) {
        this(text, false);
    }

    public HTMLText(String text, boolean antialiased) {
        super(text);
        this.setAntialiasedText(antialiased);
    }

    public HTMLText(Icon image, int horizontalAlignment) {
        super(image, horizontalAlignment);
    }

    public HTMLText(Icon image) {
        super(image);
    }

    public HTMLText() {
    }

    public void setText(String text) {
        StringBuffer newHTMLText = new StringBuffer("<html><table width={0}><tr font='Dialog'><td>");
        newHTMLText.append(text);
        newHTMLText.append("</td></tr></table></html>");
        this._htmlTextPattern = newHTMLText.toString();
        super.setText(this.getFormattedText(this.getWidth()));
    }

    private String getFormattedText(int width) {
        Object[] parameter = new Object[]{new Integer(width)};
        String result = MessageFormat.format(this._htmlTextPattern, parameter);
        return result;
    }

    public void paint(Graphics g) {
        if (this._antialiasedText) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        int width = this.getWidth();
        super.setText(this.getFormattedText(width));
        super.paint(g);
    }

    public boolean isAntialiasedText() {
        return this._antialiasedText;
    }

    public void setAntialiasedText(boolean antialiasedText) {
        this._antialiasedText = antialiasedText;
    }
}

