/*
 * Decompiled with CFR 0.152.
 */
package comfyj.generator.eclipseplugin.preferences;

import comfyj.generator.eclipseplugin.ComfyJCodeGeneratorPlugin;
import comfyj.generator.eclipseplugin.utility.ResourcesUtility;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class CodeGeneratorPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private String jdkPath;
    private String comfyJPath;
    private boolean useSpecificJDK;
    private Button useProjectJDKRadio;
    private Button useSpecificJDKRadio;
    private Button browseButton;
    private Combo useSpecificJDKCombo;
    private Text comfyJPathField;

    protected Control createContents(Composite parent) {
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CodeGeneratorPreferencePage.this.refreshControlsEnablement();
            }
        };
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Group jdkSelectionGroup = new Group(composite, 0);
        GridData layoutData = new GridData(768);
        jdkSelectionGroup.setLayoutData((Object)layoutData);
        jdkSelectionGroup.setText("JDK Settings");
        jdkSelectionGroup.setLayout((Layout)new GridLayout());
        Label description = new Label((Composite)jdkSelectionGroup, 0);
        description.setLayoutData((Object)new GridData(32));
        description.setText("Specify JDK to use for code generation and compilation");
        Composite radioComposite = new Composite((Composite)jdkSelectionGroup, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 3;
        radioComposite.setLayout((Layout)layout);
        radioComposite.setLayoutData((Object)new GridData(1808));
        this.useProjectJDKRadio = new Button(radioComposite, 16);
        this.useProjectJDKRadio.setText("Use project JDK");
        this.useProjectJDKRadio.setLayoutData((Object)new GridData(32));
        this.useProjectJDKRadio.setSelection(!this.useSpecificJDK);
        this.useProjectJDKRadio.addSelectionListener((SelectionListener)listener);
        Label projectJDK = new Label(radioComposite, 0);
        projectJDK.setText("");
        layoutData = new GridData(32);
        layoutData.horizontalSpan = 2;
        projectJDK.setLayoutData((Object)layoutData);
        this.useSpecificJDKRadio = new Button(radioComposite, 16);
        this.useSpecificJDKRadio.setText("Use specific JDK:");
        this.useSpecificJDKRadio.setLayoutData((Object)new GridData(32));
        this.useSpecificJDKRadio.setSelection(this.useSpecificJDK);
        this.useSpecificJDKRadio.addSelectionListener((SelectionListener)listener);
        this.useSpecificJDKCombo = new Combo(radioComposite, 0);
        layoutData = new GridData(768);
        layoutData.widthHint = 200;
        this.useSpecificJDKCombo.setLayoutData((Object)layoutData);
        this.useSpecificJDKCombo.setText(this.jdkPath);
        this.browseButton = new Button(radioComposite, 8);
        this.browseButton.setText("...");
        this.browseButton.setLayoutData((Object)new GridData(128));
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog directoryDialog = new DirectoryDialog(CodeGeneratorPreferencePage.this.getShell());
                directoryDialog.setText("JDK Path");
                directoryDialog.setMessage("Select JDK location");
                String path = directoryDialog.open();
                if (path != null) {
                    CodeGeneratorPreferencePage.this.useSpecificJDKCombo.setText(path);
                }
            }
        });
        Composite comfyJPathComposite = new Composite(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginHeight = 0;
        comfyJPathComposite.setLayout((Layout)layout);
        comfyJPathComposite.setLayoutData((Object)new GridData(768));
        description = new Label(comfyJPathComposite, 0);
        description.setText("ComfyJ path:");
        description.setLayoutData((Object)new GridData(32));
        this.comfyJPathField = new Text(comfyJPathComposite, 2052);
        this.comfyJPathField.setLayoutData((Object)new GridData(768));
        this.comfyJPathField.setText(this.comfyJPath);
        this.comfyJPathField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CodeGeneratorPreferencePage.this.verifyComfyJPath();
            }
        });
        Button browseComfyJButton = new Button(comfyJPathComposite, 8);
        browseComfyJButton.setText("...");
        browseComfyJButton.setLayoutData((Object)new GridData(128));
        browseComfyJButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog directoryDialog = new DirectoryDialog(CodeGeneratorPreferencePage.this.getShell());
                directoryDialog.setText("ComfyJ Path");
                directoryDialog.setMessage("Select ComfyJ location");
                String path = directoryDialog.open();
                if (path != null) {
                    CodeGeneratorPreferencePage.this.comfyJPathField.setText(path);
                }
            }
        });
        this.refreshControlsEnablement();
        this.verifyComfyJPath();
        return composite;
    }

    public void init(IWorkbench workbench) {
        IPreferenceStore store = ComfyJCodeGeneratorPlugin.getInstance().getPreferenceStore();
        this.jdkPath = store.getString("jdk.path");
        this.comfyJPath = store.getString("comfyj.path");
        this.useSpecificJDK = store.getBoolean("specific.jdk");
    }

    public boolean performOk() {
        IPreferenceStore store = ComfyJCodeGeneratorPlugin.getInstance().getPreferenceStore();
        store.setValue("jdk.path", this.useSpecificJDKCombo.getText());
        store.setValue("specific.jdk", this.useSpecificJDKRadio.getSelection());
        store.setValue("comfyj.path", this.comfyJPathField.getText());
        return super.performOk();
    }

    private void refreshControlsEnablement() {
        this.useSpecificJDKCombo.setEnabled(this.useSpecificJDKRadio.getSelection());
        this.browseButton.setEnabled(this.useSpecificJDKRadio.getSelection());
    }

    private void verifyComfyJPath() {
        String comfyJPath = this.comfyJPathField.getText();
        String errorMessage = null;
        if (!ResourcesUtility.checkComfyJLocation(comfyJPath)) {
            errorMessage = "The specified ComfyJ path is not correct.";
        } else if (!ResourcesUtility.checkComfyJVersion(comfyJPath)) {
            errorMessage = "The ComfyJ version should be 2.2 or higher.";
        }
        this.setErrorMessage(errorMessage);
        this.setValid(errorMessage == null);
    }
}

