using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using HiMap.MapControls;

namespace HiMap
{
    public partial class FrmLayerList : Form
    {
        private MapControl _mapCtrl;

        public FrmLayerList()
        {
            InitializeComponent();
        }

        /// <summary>
        /// Remove the selected layer
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void menuItem1_Click(object sender, EventArgs e)
        {
            try
            {
                int i = lvLayers.SelectedIndices[0];

                lvLayers.Items.RemoveAt(i);
                _mapCtrl.Map.RemoveAtLayer(i);

            }
            catch (Exception ex)
            {
                MessageBox.Show("error: " + ex.Message);
            }
        }


        //Close this form
        private void menuItem2_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        /// <summary>
        /// Initialization List Control
        /// </summary>
        /// <param name="mapCtrl"></param>
        public void InitLayers(MapControl mapCtrl)
        {
            _mapCtrl = mapCtrl;

            ListViewItem lvi;

            for (int i = 0; i < _mapCtrl.Map.LayerCount; i++)
            {
                lvi = new ListViewItem();
                lvi.Text = _mapCtrl.Map.GetLayer(i).Name;

                ListViewItem.ListViewSubItem sub;

                sub = new ListViewItem.ListViewSubItem();
                sub.Text = _mapCtrl.Map.GetLayer(i).Caption;
                lvi.SubItems.Add(sub);

                sub = new ListViewItem.ListViewSubItem();
                sub.Text = _mapCtrl.Map.GetLayer(i).Class.DataSource;
                lvi.SubItems.Add(sub);

                lvLayers.Items.Add(lvi);
            }
        }

    }
}