unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, ZylVSS, StdCtrls, Menus;

type
  TfrmMain = class(TForm)
    efVSS: TEdit;
    efFile: TEdit;
    cmpVSS: TZylVSS;
    MainMenu1: TMainMenu;
    mnuActions: TMenuItem;
    dlgOpen: TOpenDialog;
    btnOpen: TButton;
    AddtoVSS: TMenuItem;
    chkReadOnly: TCheckBox;
    chkKeepCheck: TCheckBox;
    chkDelete: TCheckBox;
    efComment: TEdit;
    Checkout: TMenuItem;
    chkGet: TCheckBox;
    chkReplace: TCheckBox;
    Checkin: TMenuItem;
    Label1: TLabel;
    Label2: TLabel;
    Getstatus: TMenuItem;
    lstItems: TListBox;
    Label3: TLabel;
    Getitems: TMenuItem;
    Getlinks: TMenuItem;
    Test: TMenuItem;
    GetDatabase: TMenuItem;
    GetUser: TMenuItem;
    GetName: TMenuItem;
    GetParent: TMenuItem;
    GetLocal: TMenuItem;
    GetItem: TMenuItem;
    IsDifferent: TMenuItem;
    Getversionnumber: TMenuItem;
    Childrencount: TMenuItem;
    miGetVersion: TMenuItem;
    mnuVersion: TMenuItem;
    miGetVersionLabel: TMenuItem;
    miGetVersionUsername: TMenuItem;
    miGetVersionAction: TMenuItem;
    miGetVersionComment: TMenuItem;
    miGetVersionDate: TMenuItem;
    lblVersion: TLabel;
    efVersion: TEdit;
    GetStatusEx1: TMenuItem;
    UndoCheckOut1: TMenuItem;
    procedure btnOpenClick(Sender: TObject);
    procedure AddtoVSSClick(Sender: TObject);
    procedure CheckoutClick(Sender: TObject);
    procedure CheckinClick(Sender: TObject);
    procedure GetstatusClick(Sender: TObject);
    procedure GetitemsClick(Sender: TObject);
    procedure GetlinksClick(Sender: TObject);
    procedure GetDatabaseClick(Sender: TObject);
    procedure GetUserClick(Sender: TObject);
    procedure GetNameClick(Sender: TObject);
    procedure GetParentClick(Sender: TObject);
    procedure GetLocalClick(Sender: TObject);
    procedure GetItemClick(Sender: TObject);
    procedure IsDifferentClick(Sender: TObject);
    procedure GetversionnumberClick(Sender: TObject);
    procedure ChildrencountClick(Sender: TObject);
    procedure FormShow(Sender: TObject);


    procedure miGetVersionClick(Sender: TObject);
    procedure miGetVersionLabelClick(Sender: TObject);
    procedure miGetVersionUsernameClick(Sender: TObject);
    procedure miGetVersionActionClick(Sender: TObject);
    procedure miGetVersionCommentClick(Sender: TObject);
    procedure miGetVersionDateClick(Sender: TObject);
    procedure GetStatusEx1Click(Sender: TObject);
    procedure UndoCheckOut1Click(Sender: TObject);
    //procedure GetVersion(VSSItem : WideString; Version: Integer; var LocalFile : WideString; var Error : WideString);

  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;

implementation

uses Login;
{$R *.dfm}

procedure TfrmMain.btnOpenClick(Sender: TObject);
begin
  if dlgOpen.Execute then          { Display Open dialog box }
  begin
    efFile.Text := dlgOpen.FileName;
  end;
end;

procedure TfrmMain.AddtoVSSClick(Sender: TObject);
var
  Error : WideString;
begin
  cmpVSS.Add(Trim(efVSS.Text), Trim(efFile.Text), Trim(efComment.Text), chkReadOnly.Checked, chkKeepCheck.Checked, chkDelete.Checked, Error);
  if (Error <> '') then
    ShowMessage(Error)
  else
    ShowMessage('Operation succeded.');
end;

procedure TfrmMain.CheckoutClick(Sender: TObject);
var
  Error : WideString;
begin
  cmpVSS.Checkout(Trim(efVSS.Text), Trim(efFile.Text),  Trim(efComment.Text), chkGet.Checked, chkReplace.Checked, Error);
  if (Error <> '') then
    ShowMessage(Error)
  else
    ShowMessage('Operation succeded.');
end;

procedure TfrmMain.CheckinClick(Sender: TObject);
var
  Error : WideString;
begin
  cmpVSS.Checkin(Trim(efVSS.Text), Trim(efFile.Text),  Trim(efComment.Text), chkKeepCheck.Checked, Error);
  if (Error <> '') then
    ShowMessage(Error)
  else
    ShowMessage('Operation succeded.');
end;

procedure TfrmMain.GetstatusClick(Sender: TObject);
var
  Error : WideString;
  iStatus : integer;
begin
  iStatus := cmpVSS.GetStatus(Trim(efVSS.Text), Error);
  if (Error <> '') then
    ShowMessage(Error)
  else
  begin
    if iStatus = 0 then
      ShowMessage('File is checked in.');
    if iStatus = 1 then
      ShowMessage('File is locked by another user.');
    if iStatus = 2 then
      ShowMessage('File is checked out.');
  end;
end;

procedure TfrmMain.GetitemsClick(Sender: TObject);
var
  lst : TStringList;
  Error : WideString;
  i : integer;
begin
  lstItems.Items.Clear;
  lst := cmpVSS.GetItems(Trim(efVSS.Text), Error);

  if Error <> '' then
    ShowMessage(Error)
  else
    for i := 1 to lst.Count do
      lstItems.Items.Add(lst.Strings[i-1]);
end;

procedure TfrmMain.GetlinksClick(Sender: TObject);
var
  lst : TStringList;
  Error : WideString;
  i : integer;
begin
  lstItems.Items.Clear;
  lst := cmpVSS.GetLinks(Trim(efVSS.Text), Error);

  if Error <> '' then
    ShowMessage(Error)
  else
    for i := 1 to lst.Count do
      lstItems.Items.Add(lst.Strings[i-1]);
end;

procedure TfrmMain.GetLocalClick(Sender: TObject);
var
  Error, Local : WideString;
begin
  Local := cmpVSS.GetLocalSpec(Trim(efVSS.Text), Error);
  if (Error <> '') then
    ShowMessage(Error)
  else
    efFile.Text := Local;
end;

procedure TfrmMain.ChildrencountClick(Sender: TObject);
var
  Error: WideString;
  nCount: integer;
begin
  nCount := cmpVSS.GetVersionNumber(Trim(efVSS.Text), Error);
  if (Error <> '') then
    ShowMessage(Error)
  else
    ShowMessage('Number of children: ' + IntToStr(nCount) + '.');
end;

procedure TfrmMain.GetDatabaseClick(Sender: TObject);
var
  Error, Database : WideString;
begin
  Database := cmpVSS.GetDatabaseName(Error);
  if (Error <> '') then
    ShowMessage(Error)
  else
    ShowMessage(Database);
end;

procedure TfrmMain.GetUserClick(Sender: TObject);
var
  Error, User : WideString;
begin
  User := cmpVSS.GetUserName(Error);
  if (Error <> '') then
    ShowMessage(Error)
  else
    ShowMessage(User);
end;

procedure TfrmMain.GetNameClick(Sender: TObject);
var
  Error, Name : WideString;
begin
  Name := cmpVSS.GetName(Trim(efVSS.Text), Error);
  if (Error <> '') then
    ShowMessage(Error)
  else
    ShowMessage(Name);
end;

procedure TfrmMain.GetParentClick(Sender: TObject);
var
  Error, Parent : WideString;
begin
  Parent := cmpVSS.GetParentProject(Trim(efVSS.Text), Error);
  if (Error <> '') then
    ShowMessage(Error)
  else
    ShowMessage(Parent);
end;

procedure TfrmMain.GetItemClick(Sender: TObject);
var
  Error, Item : WideString;
begin
  Item := cmpVSS.GetItem(Trim(efVSS.Text), 1, Error);
  if (Error <> '') then
    ShowMessage(Error)
  else
    ShowMessage(Item);
end;

procedure TfrmMain.IsDifferentClick(Sender: TObject);
var
  Error: WideString;
  bDiff : boolean;
begin
  bDiff := cmpVSS.IsDifferent(Trim(efVSS.Text), Trim(efFile.Text), Error);
  if (Error <> '') then
    ShowMessage(Error)
  else
    if bDiff then
      ShowMessage('Items are different.')
    else
      ShowMessage('Items are not different.');
end;

procedure TfrmMain.GetversionnumberClick(Sender: TObject);
var
  Error: WideString;
  nVers: integer;
begin
  nVers := cmpVSS.GetVersionNumber(Trim(efVSS.Text), Error);
  if (Error <> '') then
    ShowMessage(Error)
  else
    ShowMessage('Version number is: ' + IntToStr(nVers) + '.');
end;

procedure TfrmMain.FormShow(Sender: TObject);
begin
  FormLogin := TFormLogin.Create(self);
  if FormLogin.ShowModal <> mrOK then
    Application.Terminate;
end;

// Versions
procedure TfrmMain.miGetVersionClick(Sender: TObject);
var
  Error, Local : WideString;
  Version : Integer;
begin
  Local := Trim(efFile.Text);
  Version := StrToInt(Trim(efVersion.Text));
  cmpVSS.GetVersion(Trim(efVSS.Text), Version, Local, Error);
  if (Error <> '') then
    ShowMessage(Error)
  else
    ShowMessage(Local);
end;

procedure TfrmMain.miGetVersionLabelClick(Sender: TObject);
var
  Error, Label_ : WideString;
  Version : Integer;
begin
  Version := StrToInt(Trim(efVersion.Text));
  Label_ := cmpVSS.GetVersionLabel(Trim(efVSS.Text), Version, Error);
  if (Error <> '') then
    ShowMessage(Error)
  else
    ShowMessage(Label_);
end;

procedure TfrmMain.miGetVersionUsernameClick(Sender: TObject);
var
  Error, Username : WideString;
  Version : Integer;
begin
  Version := StrToInt(Trim(efVersion.Text));
  Username := cmpVSS.GetVersionUsername(Trim(efVSS.Text), Version, Error);
  if (Error <> '') then
    ShowMessage(Error)
  else
    ShowMessage(Username);
end;

procedure TfrmMain.miGetVersionActionClick(Sender: TObject);
var
  Error, Action : WideString;
  Version : Integer;
begin
  Version := StrToInt(Trim(efVersion.Text));
  Action := cmpVSS.GetVersionAction(Trim(efVSS.Text), Version, Error);
  if (Error <> '') then
    ShowMessage(Error)
  else
    ShowMessage(Action);
end;

procedure TfrmMain.miGetVersionCommentClick(Sender: TObject);
var
  Error, Comment : WideString;
  Version : Integer;
begin
  Version := StrToInt(Trim(efVersion.Text));
  Comment := cmpVSS.GetVersionComment(Trim(efVSS.Text), Version, Error);
  if (Error <> '') then
    ShowMessage(Error)
  else
    ShowMessage(Comment);
end;

procedure TfrmMain.miGetVersionDateClick(Sender: TObject);
var
  Error, strDate : WideString;
  Version : Integer;
  DDate : TDateTime;
begin
  Version := StrToInt(Trim(efVersion.Text));
  DDate := cmpVSS.GetVersionDate(Trim(efVSS.Text), Version, Error);
  strDate := DateToStr(DDate);
  if (Error <> '') then
    ShowMessage(Error)
  else
    ShowMessage(strDate);
end;

procedure TfrmMain.GetStatusEx1Click(Sender: TObject);
var
  Error : WideString;
  objStatus : TList;
  objCheckOut: TVSSCheckout;
  i: Integer;
begin
  objStatus := cmpVSS.GetStatusEx(Trim(efVSS.Text), Error);
  if (Error <> '') then
    ShowMessage(Error)
  else
  begin
    if Assigned(objStatus) then
    begin
      lstItems.Items.Clear;
      for i := 0 to objStatus.Count - 1 do
      begin
        objCheckOut := TVSSCheckout(objStatus[i]);
        lstItems.Items.Add('UserName: ' + objCheckOut.UserName);
        lstItems.Items.Add('Date: ' + DateToStr(objCheckOut.Date));
        lstItems.Items.Add('LocalSpec: ' + objCheckOut.LocalSpec);
        lstItems.Items.Add('Machine: ' + objCheckOut.Machine);
        lstItems.Items.Add('Project: ' + objCheckOut.Project);
        lstItems.Items.Add('Comment: ' + objCheckOut.Comment);
        lstItems.Items.Add('VersionNumber: ' + IntToStr(objCheckOut.VersionNumber));
        lstItems.Items.Add('-----------------------------------');
        objCheckout.Free;
      end;
      objStatus.Free();
    end;
  end;

end;

procedure TfrmMain.UndoCheckOut1Click(Sender: TObject);
var
  Error : WideString;
begin
  cmpVSS.UndoCheckout(Trim(efVSS.Text), Trim(efFile.Text), chkDelete.Checked, Error);
  if (Error <> '') then
    ShowMessage(Error)
  else
    ShowMessage('Operation succeded.');
end;

end.
