CREATE OR REPLACE VIEW SVCO.REPOSITORY_LOG
(
    SCHEMANAME,
    REVISION,
    VERSION,
    CREATED,
    COMMENTS
)
AS
select owner_name, rev_num, ext_vers, created, comments
 from version_log l
 where l.db_name = upper(sys_context('USERENV', 'DB_NAME')) and
 (exists (select 1 from USER_ROLE_PRIVS r where r.granted_role = 'SVCO_REP_ADMIN') or l.owner_name = user)
/
COMMENT ON TABLE SVCO.REPOSITORY_LOG IS
'All schema revisions from SVCO repository'
/
COMMENT ON COLUMN SVCO.REPOSITORY_LOG.SCHEMANAME IS
'Schema (user owner) name'
/
COMMENT ON COLUMN SVCO.REPOSITORY_LOG.REVISION IS
'Internal Revision Number'
/
COMMENT ON COLUMN SVCO.REPOSITORY_LOG.VERSION IS
'External Version'
/
COMMENT ON COLUMN SVCO.REPOSITORY_LOG.CREATED IS
'When created'
/
----------------------------------------------------
CREATE OR REPLACE VIEW SVCO.REPOSITORY_OBJECTS_LOG
(
    SCHEMANAME,
    REVISION,
    OBJECTTYPE,
    OBJECTNAME,
    OBJECTSTATUS,
    REFERENCESCHEMANAME,
    REFERENCEREVISION
)
AS
select l.owner_name
      ,l.rev_num
      ,o.object_type
      ,o.object_name
      ,decode(o.object_status
             ,'I'
             ,'New'
             ,'U'
             ,'Changed'
             ,'D'
             ,'Deleted'
             ,'R'
             ,'Referenced')
      ,l2.owner_name
      ,l2.rev_num
  from version_log l, version_objects o, version_objects o2, version_log l2
 where l.db_name = upper(sys_context('USERENV', 'DB_NAME'))
   and (exists
        (select 1
           from USER_ROLE_PRIVS r
          where r.granted_role = 'SVCO_REP_ADMIN') or l.owner_name = user)
   and l.internal_id = o.version_log_id
   and o.parent_version_objects_id = o2.version_objects_id(+)
   and o2.version_log_id = l2.internal_id(+)
/
COMMENT ON TABLE SVCO.REPOSITORY_OBJECTS_LOG IS
'All objects in each schema revision from SVCO repository'
/
COMMENT ON COLUMN SVCO.REPOSITORY_OBJECTS_LOG.SCHEMANAME IS
'Schema (user owner) name'
/
COMMENT ON COLUMN SVCO.REPOSITORY_OBJECTS_LOG.REVISION IS
'Internal Revision Number'
/
COMMENT ON COLUMN SVCO.REPOSITORY_OBJECTS_LOG.REFERENCESCHEMANAME IS
'Reference schema (user owner) name'
/
COMMENT ON COLUMN SVCO.REPOSITORY_OBJECTS_LOG.REFERENCEREVISION IS
'Reference schema Internal Revision Number'
/
