create or replace package SVCO.repository_admin authid current_user is
  /*
  * "Schema Version Control for Oracle" (SVCO)
  *      http://www.sumsoftsolutions.com
  * PLEASE READ LICENSE AGREEMENT CAREFULLY BEFORE USING THIS SOFTWARE
  *
  * PURPOSE
  * This package is the user interface to an administrator repository functions.
  *
  * SECURITY
  * This package is granted to SVCO_REP_ADMIN role.
  */

  --
  -- DESCRIPTION
  -- This procedure saves purchased LICENSE KEY for SVCO product.
  --
  -- PARAMETERS
  -- Key - a purchased LICENSE KEY
  --
  -- EXCEPTIONS
  -- repository_util.exc_license_key
  -- exceptions_.exc_unhandled
  --
  -- TRANSACTION
  -- This procedure performs a transaction.
  --
  procedure SaveLicenseKey(Key in char);

  --
  -- DESCRIPTION
  -- This procedure checks for a newest available SVCO version.
  -- Requires internet connection for database server.
  -- NO SENSITIVE INFORMATION IS SEND TO THE INTERNET WHILE PROCEDURE WORKING.
  --
  -- PARAMETERS
  -- HTTPProxy - The HTTP proxy host and port number. The syntax is
  --             [http://]host[:port][/]  For example, www-proxy.my-company.com:80
  --             or null if no HTTP proxy for internet connection is required.
  --
  -- EXCEPTIONS
  -- exceptions_.exc_update_chk
  -- exceptions_.exc_unhandled
  --
  -- TRANSACTION
  -- No.
  --
  procedure CheckSoftwareUpdate(HTTPProxy in varchar2 default null);

  --
  -- DESCRIPTION
  -- This procedure delete the last revision from repository for given SchemaName.
  --
  -- PARAMETERS
  -- SchemaName - Schema name (user name). Case insensitive.
  --
  -- EXCEPTIONS
  -- exceptions_.exc_no_data_found
  -- exceptions_.exc_unhandled
  --
  -- TRANSACTION
  -- This procedure starts a transaction. YOU SHOULD ISSUE COMMIT OR ROLLBACK TO FINISH IT.
  --
  procedure DeleteLastRevision(SchemaName in varchar2);

  --
  -- DESCRIPTION
  -- This procedure returns a DDL script for the hole schema revision or 
  -- only for given object type in revision or only for given object.
  --
  -- PARAMETERS
  -- SchemaName - Schema name (user name). Case insensitive.
  --
  -- DDL - DDL script
  -- 
  -- Revision - Revision number, if not given - last revision.
  --
  -- Version - User identifier for revision, if not given - last revision.
  --
  -- ObjectName - Object name. Case insensitive.
  --
  -- ObjectType - Object type. Case insensitive.
  --
  -- NewSchemaName - To be given when all objects are prefixed
  --                 with this schema name instead of original. Case insensitive.
  --
  -- EXCEPTIONS
  -- exceptions_.exc_no_data_found
  -- exceptions_.exc_too_many_rows
  -- exceptions_.exc_req_param
  -- exceptions_.exc_unhandled
  --
  -- TRANSACTION
  -- No.
  --
  procedure CreateDDLFromRevision(SchemaName    in varchar2
                                 ,DDL           out clob
                                 ,Revision      in number default null
                                 ,Version       in varchar2 default null
                                 ,ObjectName    in varchar2 default null
                                 ,ObjectType    in varchar2 default null
                                 ,NewSchemaName in varchar2 default null);

end repository_admin;
/
