VERSION 5.00
Object = "{F89D666A-0ECC-4FE3-8A88-C4291D362C41}#11.0#0"; "rspgzip201.ocx"
Begin VB.Form Form1 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "RSP GZip Compressor OCX - Sample"
   ClientHeight    =   4605
   ClientLeft      =   150
   ClientTop       =   435
   ClientWidth     =   7305
   Icon            =   "Form1.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   4605
   ScaleWidth      =   7305
   StartUpPosition =   2  'CenterScreen
   Begin RSPGZip201.ProgBar ProgBar1 
      Height          =   375
      Left            =   120
      Top             =   3000
      Width           =   7095
      _ExtentX        =   12515
      _ExtentY        =   661
      Value           =   0
   End
   Begin VB.CheckBox Check2 
      Caption         =   "Use Gzip2 ( recommended )"
      Height          =   255
      Left            =   120
      TabIndex        =   19
      Top             =   1440
      Value           =   1  'Checked
      Width           =   2655
   End
   Begin RSPGZip201.RSPGzip RSPGzip1 
      Left            =   4680
      Top             =   2280
      _ExtentX        =   979
      _ExtentY        =   979
   End
   Begin VB.CheckBox Check1 
      Caption         =   "Wait execution"
      Height          =   255
      Left            =   120
      TabIndex        =   18
      Top             =   1680
      Width           =   1935
   End
   Begin VB.ComboBox Combo1 
      Height          =   315
      Left            =   600
      TabIndex        =   15
      Top             =   1920
      Width           =   495
   End
   Begin VB.CommandButton Command9 
      Caption         =   "Select"
      Height          =   375
      Left            =   2160
      TabIndex        =   13
      Top             =   960
      Width           =   855
   End
   Begin VB.CommandButton Command8 
      Caption         =   "Select"
      Height          =   375
      Left            =   2160
      TabIndex        =   12
      Top             =   480
      Width           =   855
   End
   Begin VB.CommandButton Command7 
      Caption         =   "Select"
      Height          =   375
      Left            =   2160
      TabIndex        =   11
      Top             =   0
      Width           =   855
   End
   Begin VB.ListBox List1 
      Height          =   450
      Left            =   120
      TabIndex        =   10
      Top             =   3720
      Width           =   7095
   End
   Begin VB.CommandButton Command6 
      Caption         =   "Cancel"
      Height          =   615
      Left            =   3000
      TabIndex        =   9
      Top             =   2280
      Width           =   1335
   End
   Begin VB.CommandButton Command5 
      Caption         =   "Resume"
      Height          =   615
      Left            =   1560
      TabIndex        =   8
      Top             =   2280
      Width           =   1335
   End
   Begin VB.CommandButton Command4 
      Caption         =   "Pause"
      Height          =   615
      Left            =   120
      TabIndex        =   7
      Top             =   2280
      Width           =   1335
   End
   Begin VB.CommandButton Command3 
      Caption         =   "Exit"
      Height          =   615
      Left            =   5880
      TabIndex        =   6
      Top             =   2280
      Width           =   1335
   End
   Begin VB.TextBox Text3 
      Height          =   375
      Left            =   3120
      TabIndex        =   4
      Top             =   960
      Width           =   4095
   End
   Begin VB.CommandButton Command2 
      Caption         =   "Uncompress"
      Height          =   375
      Left            =   120
      TabIndex        =   3
      Top             =   480
      Width           =   1815
   End
   Begin VB.TextBox Text2 
      Height          =   375
      Left            =   3120
      TabIndex        =   2
      Top             =   480
      Width           =   4095
   End
   Begin VB.TextBox Text1 
      Height          =   375
      Left            =   3120
      TabIndex        =   1
      Top             =   0
      Width           =   4095
   End
   Begin VB.CommandButton Command1 
      Caption         =   "Compress"
      Height          =   375
      Left            =   120
      TabIndex        =   0
      Top             =   0
      Width           =   1815
   End
   Begin VB.Label Label7 
      Caption         =   "RSP Software 1996-2008"
      ForeColor       =   &H00FF0000&
      Height          =   255
      Left            =   5400
      TabIndex        =   17
      Top             =   4320
      Width           =   2535
   End
   Begin VB.Label Label3 
      Caption         =   "Level:"
      Height          =   255
      Left            =   120
      TabIndex        =   16
      Top             =   1995
      Width           =   615
   End
   Begin VB.Label Label2 
      Caption         =   "Elapsed :"
      Height          =   255
      Left            =   120
      TabIndex        =   14
      Top             =   4200
      Width           =   2295
   End
   Begin VB.Label Label1 
      Caption         =   "Errors:"
      Height          =   255
      Left            =   120
      TabIndex        =   5
      Top             =   3480
      Width           =   1455
   End
   Begin VB.Menu about 
      Caption         =   "About"
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'RSP Software - Tue Nov 13 20:39:51 2007

'2.0.0 sample project
'the sample will show how to use the gzip control

'Only use the old Gzip method if you really need it , for
'new projects use the Gzip2 version , it is faster and has no file size limit ,
'plus a very good quality file integrity checksum , the very well
'known MD5

Private Declare Function GetTickCount Lib "kernel32" () As Long

Dim First As Long 'To hold profile variable

Private Sub about_Click()
    RSPGzip1.About
End Sub

Private Sub Command1_Click()

    Dim Ret As Long

    Label2.Caption = "Elapsed : ..."

    First = GetTickCount

    If Check1.Value = 1 Then
        'This property will define whether the return of the function
        'will occur immediately or only after the execution
        RSPGzip1.WaitExecution = True
    Else
        RSPGzip1.WaitExecution = False
    End If

    'The compression level (Combo1.Text) range from 1 to 9 ,
    '9 for best compression

    If Check2.Value = 0 Then
        'Old mode , standard Gzip file mode , limited to 2 GB of size
        'and very simple Adler32 checksum
        RSPGzip1.Compress Text1.Text, Text2.Text, Combo1.Text
    Else
        'Gzip2 mode is Recommended , it has no file size limit and uses
        'the very good quality MD5 checksum
        RSPGzip1.CompressGzip2 Text1.Text, Text2.Text, Combo1.Text
    End If

    Debug.Print Now & " Finished"

End Sub

Private Sub Command2_Click()

    Label2.Caption = "Elapsed : ..."

    First = GetTickCount

    If Check1.Value = 1 Then
        ' This property will define whether the return of the function will occur immediately or only after the execution
        RSPGzip1.WaitExecution = True
    Else
        RSPGzip1.WaitExecution = False
    End If

    If Check2.Value = 0 Then
        RSPGzip1.Uncompress Text2.Text, Text3.Text
    Else
        RSPGzip1.UncompressGzip2 Text2.Text, Text3.Text
    End If

    Debug.Print Now & " Finished"

End Sub

Private Sub Command3_Click()
    Unload Form1
    Set Form1 = Nothing
End Sub

Private Sub Command4_Click()
    RSPGzip1.PauseExecution
End Sub

Private Sub Command5_Click()
    RSPGzip1.ResumeExecution
End Sub

Private Sub Command6_Click()
    RSPGzip1.CancelExecution
End Sub

Private Sub Command7_Click()

    'OpenFile is a replacement for the CommonDialog OCX
    Text1.Text = RSPGzip1.OpenFile("Select file to compress", "All files (*.*)|*.*", "")

End Sub

Private Sub Command8_Click()

    Text2.Text = RSPGzip1.OpenFile("Select destination compressed file", "All files (*.*)|*.*", "")

End Sub

Private Sub Command9_Click()

    Text3.Text = RSPGzip1.OpenFile("Select file to uncompress", "All files (*.*)|*.*", "")

End Sub

Private Sub Form_Load()

    Combo1.AddItem 1
    Combo1.AddItem 2
    Combo1.AddItem 3
    Combo1.AddItem 4
    Combo1.AddItem 5
    Combo1.AddItem 6
    Combo1.AddItem 7
    Combo1.AddItem 8
    Combo1.AddItem 9
    Combo1.Text = 6

    Form1.Caption = RSPGzip1.ControlName & " - Sample Project "

End Sub

Private Sub RSPGzip1_ErrorCode(ErrorNumber As Long, ErrorDescription As String)

    'The error number and error descriptions are self-explanatory

    Static NumberOfErrors As Long

    NumberOfErrors = NumberOfErrors + 1

    List1.AddItem NumberOfErrors & " : " & ErrorNumber & " : " & ErrorDescription    'This event is raised in any exception

    Dim Ret As Long
    Ret = List1.ListCount
    List1.ListIndex = Ret - 1

    'Possible error codes and descriptions are:
    '0, "No error"
    '2, "The input file is the same as the output'
    '3, "The input file is empty"
    '4, "The outputfile file is empty"
    '5, "The input file or path is invalid"
    '6, "The output file or path is invalid"
    '7, "Error opening input file"
    '8, "Error opening output file"
    '9, "Invalid gzip file"
    '10, "Error opening gzip file for read"
    '11, "Error opening output file for write"
    '12, "Invalid compression level"
    '13, "Already running , cancel the execution or wait"
    '14, "Unable to write to the destination file"
    '15, "CRC or MD5 data error"
    '16, "Unexpected error during compression"
    '18, "Unexpected error during uncompression"
    '19, "User abort"
    '255, "Unexpected error"

End Sub

Private Sub RSPGzip1_Finished()

    'This event is raised in the end of the execution

    First = GetTickCount - First

    Label2.Caption = "Elapsed : " & First

End Sub

Private Sub RSPGzip1_Progress(ByVal ProgressValue As Long)

    'Version 2.0.0 and above has a progressbar embedded
    ProgBar1.Value = ProgressValue

    'It avoid the utilization of the Microsoft Windows Common Controls

End Sub

'Rsp Software 13/11/2007 21:25:59 - http://rspsoftware.bighost.com.br  info@rspsoftware.bighost.com.br
