/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.gui.plaf.skin.impl.gtk;

import com.l2fprod.gui.plaf.skin.DefaultButton;
import com.l2fprod.gui.plaf.skin.SkinSlider;
import com.l2fprod.gui.plaf.skin.impl.AbstractSkinSlider;
import com.l2fprod.gui.plaf.skin.impl.gtk.GtkUtils;
import com.l2fprod.gui.plaf.skin.impl.gtk.parser.GtkParser;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.SwingConstants;

final class GtkSlider
extends AbstractSkinSlider
implements SkinSlider,
SwingConstants {
    DefaultButton h_track;
    DefaultButton v_track;
    DefaultButton h_thumb;
    DefaultButton v_thumb;

    public GtkSlider(GtkParser gtkParser) throws Exception {
        this.h_thumb = GtkUtils.newButton(gtkParser, "GtkRange", new String[]{"function", "orientation"}, new String[]{"SLIDER", "HORIZONTAL"}, true);
        this.v_thumb = GtkUtils.newButton(gtkParser, "GtkRange", new String[]{"function", "orientation"}, new String[]{"SLIDER", "VERTICAL"}, true);
        this.h_track = GtkUtils.newButton(gtkParser, "GtkRange", new String[]{"function", "detail", "orientation"}, new String[]{"BOX", "trough", "HORIZONTAL"});
        this.v_track = GtkUtils.newButton(gtkParser, "GtkRange", new String[]{"function", "detail", "orientation"}, new String[]{"BOX", "trough", "VERTICAL"});
    }

    public Dimension getPreferredSize(JSlider jSlider, Dimension dimension) {
        if (jSlider.getOrientation() == 0) {
            dimension.height = Math.max(dimension.height, this.h_thumb.getHeight());
        } else {
            dimension.width = Math.max(dimension.width, this.v_thumb.getWidth());
        }
        return dimension;
    }

    public Dimension getThumbSize(JSlider jSlider) {
        if (this.h_thumb != null) {
            if (jSlider.getOrientation() == 0) {
                return this.h_thumb.getPreferredSize();
            }
            return this.v_thumb.getPreferredSize();
        }
        return null;
    }

    public boolean status() {
        return true;
    }

    public boolean installSkin(JComponent jComponent) {
        jComponent.setOpaque(false);
        return true;
    }

    public boolean paintTrack(Graphics graphics, JSlider jSlider, Rectangle rectangle) {
        if (this.h_track != null) {
            if (jSlider.getOrientation() == 0) {
                this.h_track.paint(graphics, 0, 0, rectangle.width, rectangle.height, jSlider);
            } else {
                this.v_track.paint(graphics, 0, 0, rectangle.width, rectangle.height, jSlider);
            }
            return true;
        }
        return false;
    }

    public boolean paintThumb(Graphics graphics, JSlider jSlider, Rectangle rectangle) {
        if (this.h_thumb != null) {
            if (jSlider.getOrientation() == 0) {
                this.h_thumb.paint(graphics, 0, 0, this.h_thumb.getWidth(), this.h_thumb.getHeight(), jSlider);
            } else {
                this.v_thumb.paint(graphics, 0, 0, this.v_thumb.getWidth(), this.v_thumb.getHeight(), jSlider);
            }
            return true;
        }
        return false;
    }
}

