/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.gui.plaf.skin;

import com.l2fprod.gui.plaf.skin.Skin;
import com.l2fprod.gui.plaf.skin.SkinLookAndFeel;
import com.l2fprod.gui.plaf.skin.SkinTitlePane;
import com.l2fprod.gui.plaf.skin.Window;
import com.l2fprod.util.AccessUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JRootPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicRootPaneUI;

public final class SkinRootPaneUI
extends BasicRootPaneUI {
    public static final int Frame_MAXIMIZED_BOTH = AccessUtils.getIntValue(class$javax$swing$JFrame == null ? (class$javax$swing$JFrame = SkinRootPaneUI.class$("javax.swing.JFrame")) : class$javax$swing$JFrame, "MAXIMIZED_BOTH");
    public static final int JRootPane_NONE = AccessUtils.getIntValue(class$javax$swing$JRootPane == null ? (class$javax$swing$JRootPane = SkinRootPaneUI.class$("javax.swing.JRootPane")) : class$javax$swing$JRootPane, "NONE");
    private Skin skin = SkinLookAndFeel.getSkin();
    private Window.FrameWindow title = null;
    private static final String[] borderKeys = new String[]{null, "RootPane.frameBorder", "RootPane.plainDialogBorder", "RootPane.informationDialogBorder", "RootPane.errorDialogBorder", "RootPane.colorChooserDialogBorder", "RootPane.fileChooserDialogBorder", "RootPane.questionDialogBorder", "RootPane.warningDialogBorder"};
    private static final int CORNER_DRAG_WIDTH = 16;
    private static final int BORDER_DRAG_THICKNESS = 5;
    private Window window;
    private SkinTitlePane titlePane;
    private MouseInputListener mouseInputListener;
    private LayoutManager layoutManager;
    private LayoutManager savedOldLayout;
    private JRootPane root;
    private Cursor lastCursor = Cursor.getPredefinedCursor(0);
    private static final int[] cursorMapping = new int[]{6, 6, 8, 7, 7, 6, 0, 0, 0, 7, 10, 0, 0, 0, 11, 4, 0, 0, 0, 5, 4, 4, 9, 5, 5};
    static /* synthetic */ Class class$javax$swing$JFrame;
    static /* synthetic */ Class class$javax$swing$JRootPane;
    static /* synthetic */ Class class$com$l2fprod$gui$plaf$skin$SkinTitlePane;

    public static int getExtendedState(Frame frame) {
        return AccessUtils.getAsInt(frame, "getExtendedState");
    }

    public static void setExtendedState(Frame frame, int n) {
        AccessUtils.setAsInt(frame, "setExtendedState", n);
    }

    public static int getWindowDecorationStyle(JRootPane jRootPane) {
        return AccessUtils.getAsInt(jRootPane, "getWindowDecorationStyle");
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SkinRootPaneUI();
    }

    private static Window translateSource(MouseEvent mouseEvent) {
        Window window;
        Object object = mouseEvent.getSource();
        if (object.getClass() == (class$com$l2fprod$gui$plaf$skin$SkinTitlePane == null ? (class$com$l2fprod$gui$plaf$skin$SkinTitlePane = SkinRootPaneUI.class$("com.l2fprod.gui.plaf.skin.SkinTitlePane")) : class$com$l2fprod$gui$plaf$skin$SkinTitlePane)) {
            SkinTitlePane skinTitlePane = (SkinTitlePane)object;
            Window.FrameWindow frameWindow = (Window.FrameWindow)skinTitlePane.getWindow();
            window = frameWindow.getMainFrame();
        } else {
            window = (Window)mouseEvent.getSource();
        }
        return window;
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.root = (JRootPane)jComponent;
        int n = SkinRootPaneUI.getWindowDecorationStyle(this.root);
        if (n != JRootPane_NONE) {
            this.installClientDecorations(this.root);
        }
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        this.uninstallClientDecorations(this.root);
        this.layoutManager = null;
        this.mouseInputListener = null;
        this.root = null;
    }

    void installBorder(JRootPane jRootPane) {
        int n = SkinRootPaneUI.getWindowDecorationStyle(jRootPane);
        if (n == JRootPane_NONE) {
            LookAndFeel.uninstallBorder(jRootPane);
        } else {
            this.skin.getFrame().installSkin(jRootPane);
        }
    }

    private void uninstallBorder(JRootPane jRootPane) {
        LookAndFeel.uninstallBorder(jRootPane);
    }

    private void installWindowListeners(JRootPane jRootPane, Component component) {
        this.window = component instanceof Window ? (Window)component : SwingUtilities.getWindowAncestor(component);
        if (this.window != null) {
            if (this.mouseInputListener == null) {
                this.mouseInputListener = this.createWindowMouseInputListener(jRootPane);
            }
            this.window.addMouseListener(this.mouseInputListener);
            this.window.addMouseMotionListener(this.mouseInputListener);
        }
    }

    private void uninstallWindowListeners(JRootPane jRootPane) {
        if (this.window != null) {
            this.window.removeMouseListener(this.mouseInputListener);
            this.window.removeMouseMotionListener(this.mouseInputListener);
        }
    }

    private void installLayout(JRootPane jRootPane) {
        if (this.layoutManager == null) {
            this.layoutManager = this.createLayoutManager();
        }
        this.savedOldLayout = jRootPane.getLayout();
        jRootPane.setLayout(this.layoutManager);
    }

    private void uninstallLayout(JRootPane jRootPane) {
        if (this.savedOldLayout != null) {
            jRootPane.setLayout(this.savedOldLayout);
            this.savedOldLayout = null;
        }
    }

    private void installClientDecorations(JRootPane jRootPane) {
        this.installBorder(jRootPane);
        JComponent jComponent = this.createTitlePane(jRootPane);
        this.setTitlePane(jRootPane, jComponent);
        this.installWindowListeners(jRootPane, jRootPane.getParent());
        this.installLayout(jRootPane);
        this.adjustIconAndBackground();
        if (this.window != null) {
            jRootPane.revalidate();
            jRootPane.repaint();
        }
    }

    private void adjustIconAndBackground() {
        if (this.window != null) {
            Object object;
            Object object2;
            this.title.setFrame(this.window);
            this.titlePane.enableActions();
            String[] stringArray = this.skin.getColors();
            boolean bl = true;
            for (int i = 0; i < stringArray.length && bl; ++i) {
                object2 = stringArray[i];
                if (!((String)object2).equalsIgnoreCase("desktop")) continue;
                bl = false;
                try {
                    object = Color.decode(stringArray[i + 1]);
                    this.window.setBackground((Color)object);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            Window window = this.title.getMainFrame();
            if (window instanceof JFrame) {
                object2 = (JFrame)window;
                object = this.titlePane.getWindow().getFrameIcon();
                Icon icon = UIManager.getIcon("InternalFrame.icon");
                Icon icon2 = object;
                if (object == null) {
                    icon2 = icon;
                }
                if (icon2 != null) {
                    BufferedImage bufferedImage = new BufferedImage(icon2.getIconWidth(), icon2.getIconHeight(), 2);
                    Graphics graphics = bufferedImage.getGraphics();
                    icon2.paintIcon(null, graphics, 0, 0);
                    ((JFrame)object2).setIconImage(bufferedImage);
                }
            }
        }
    }

    private void resetIconAndBackground() {
        if (this.window != null) {
            this.window.setBackground(null);
            this.title.setFrame(null);
        }
    }

    private void uninstallClientDecorations(JRootPane jRootPane) {
        this.uninstallBorder(jRootPane);
        this.uninstallWindowListeners(jRootPane);
        this.setTitlePane(jRootPane, null);
        this.uninstallLayout(jRootPane);
        this.resetIconAndBackground();
        int n = SkinRootPaneUI.getWindowDecorationStyle(jRootPane);
        if (n == JRootPane_NONE) {
            jRootPane.repaint();
            jRootPane.revalidate();
        }
        if (this.window != null) {
            this.window.setCursor(Cursor.getPredefinedCursor(0));
        }
        this.window = null;
    }

    private JComponent createTitlePane(JRootPane jRootPane) {
        this.title = new Window.FrameWindow();
        SkinTitlePane skinTitlePane = new SkinTitlePane(this.title){

            protected JMenu createSystemMenu() {
                JMenu jMenu = new JMenu("    ");
                jMenu.getPopupMenu().setLightWeightPopupEnabled(false);
                return jMenu;
            }
        };
        skinTitlePane.setOpaque(false);
        return skinTitlePane;
    }

    private MouseInputListener createWindowMouseInputListener(JRootPane jRootPane) {
        return new MouseInputHandler();
    }

    private LayoutManager createLayoutManager() {
        return new MetalRootLayout();
    }

    private void setTitlePane(JRootPane jRootPane, JComponent jComponent) {
        JLayeredPane jLayeredPane = jRootPane.getLayeredPane();
        JComponent jComponent2 = this.getTitlePane();
        if (jComponent2 != null) {
            jComponent2.setVisible(false);
            jLayeredPane.remove(jComponent2);
        }
        if (jComponent != null) {
            jLayeredPane.add((Component)jComponent, JLayeredPane.FRAME_CONTENT_LAYER);
            jComponent.setVisible(true);
        }
        this.titlePane = (SkinTitlePane)jComponent;
    }

    private JComponent getTitlePane() {
        return this.titlePane;
    }

    private Window.FrameWindow getFrameWindow() {
        return this.title;
    }

    private Window getMainWindow() {
        return this.window;
    }

    private JRootPane getRootPane() {
        return this.root;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        String string = propertyChangeEvent.getPropertyName();
        if (string == null) {
            return;
        }
        if (string.equals("windowDecorationStyle")) {
            JRootPane jRootPane = (JRootPane)propertyChangeEvent.getSource();
            int n = SkinRootPaneUI.getWindowDecorationStyle(jRootPane);
            this.uninstallClientDecorations(jRootPane);
            if (n != JRootPane_NONE) {
                this.installClientDecorations(jRootPane);
            }
        } else if (string.equals("ancestor")) {
            this.uninstallWindowListeners(this.root);
            if (SkinRootPaneUI.getWindowDecorationStyle((JRootPane)propertyChangeEvent.getSource()) != JRootPane_NONE) {
                this.installWindowListeners(this.root, this.root.getParent());
            }
        }
    }

    public static void adjust(Rectangle rectangle, Dimension dimension, int n, int n2, int n3, int n4) {
        rectangle.x += n;
        rectangle.y += n2;
        rectangle.width += n3;
        rectangle.height += n4;
        if (dimension != null) {
            int n5;
            if (rectangle.width < dimension.width) {
                n5 = dimension.width - rectangle.width;
                if (n != 0) {
                    rectangle.x -= n5;
                }
                rectangle.width = dimension.width;
            }
            if (rectangle.height < dimension.height) {
                n5 = dimension.height - rectangle.height;
                if (n2 != 0) {
                    rectangle.y -= n5;
                }
                rectangle.height = dimension.height;
            }
        }
    }

    public static int calculateCorner(Component component, int n, int n2) {
        int n3 = SkinRootPaneUI.calculatePosition(n, component.getWidth());
        int n4 = SkinRootPaneUI.calculatePosition(n2, component.getHeight());
        if (n3 == -1 || n4 == -1) {
            return -1;
        }
        return n4 * 5 + n3;
    }

    public static int getCursor(int n) {
        if (n == -1) {
            return 0;
        }
        return cursorMapping[n];
    }

    public static int calculatePosition(int n, int n2) {
        if (n < 5) {
            return 0;
        }
        if (n < 16) {
            return 1;
        }
        if (n >= n2 - 5) {
            return 4;
        }
        if (n >= n2 - 16) {
            return 3;
        }
        return 2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class MouseInputHandler
    implements MouseInputListener {
        private boolean isMovingWindow;
        private int dragCursor;
        private int dragOffsetX;
        private int dragOffsetY;
        private int dragWidth;
        private int dragHeight;

        private MouseInputHandler() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (SkinRootPaneUI.getWindowDecorationStyle(SkinRootPaneUI.this.root) == JRootPane_NONE) {
                return;
            }
            Point point = mouseEvent.getPoint();
            Window window = SkinRootPaneUI.translateSource(mouseEvent);
            if (window != null) {
                window.toFront();
            }
            Point point2 = SwingUtilities.convertPoint(window, point, SkinRootPaneUI.this.getTitlePane());
            if (SkinRootPaneUI.this.getTitlePane() != null && SkinRootPaneUI.this.getTitlePane().contains(point2) && !SkinRootPaneUI.this.getFrameWindow().isMaximum() && point.y >= 5 && point.x >= 5 && point.x < window.getWidth() - 5) {
                this.isMovingWindow = true;
                this.dragOffsetX = point.x;
                this.dragOffsetY = point.y;
            }
            if (SkinRootPaneUI.this.getFrameWindow().isResizable() && !SkinRootPaneUI.this.getFrameWindow().isShaded() && !SkinRootPaneUI.this.getFrameWindow().isMaximum()) {
                this.dragOffsetX = point.x;
                this.dragOffsetY = point.y;
                this.dragWidth = window.getWidth();
                this.dragHeight = window.getHeight();
                this.dragCursor = SkinRootPaneUI.getCursor(SkinRootPaneUI.calculateCorner(window, point.x, point.y));
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.dragCursor != 0 && SkinRootPaneUI.this.window != null && !SkinRootPaneUI.this.window.isValid()) {
                SkinRootPaneUI.this.window.validate();
                SkinRootPaneUI.this.getRootPane().repaint();
            }
            this.isMovingWindow = false;
            this.dragCursor = 0;
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            JRootPane jRootPane = SkinRootPaneUI.this.getRootPane();
            if (SkinRootPaneUI.getWindowDecorationStyle(jRootPane) == JRootPane_NONE) {
                return;
            }
            Window window = SkinRootPaneUI.translateSource(mouseEvent);
            int n = SkinRootPaneUI.getCursor(SkinRootPaneUI.calculateCorner(window, mouseEvent.getX(), mouseEvent.getY()));
            if (n != 0 && SkinRootPaneUI.this.getFrameWindow().isResizable() && !SkinRootPaneUI.this.getFrameWindow().isShaded() && !SkinRootPaneUI.this.getFrameWindow().isMaximum()) {
                window.setCursor(Cursor.getPredefinedCursor(n));
            } else {
                window.setCursor(SkinRootPaneUI.this.lastCursor);
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            Window window = SkinRootPaneUI.translateSource(mouseEvent);
            Point point = mouseEvent.getPoint();
            if (this.isMovingWindow) {
                Point point2 = window.getLocationOnScreen();
                point2.x += point.x - this.dragOffsetX;
                point2.y += point.y - this.dragOffsetY;
                window.setLocation(point2);
            } else if (this.dragCursor != 0) {
                Rectangle rectangle = window.getBounds();
                Rectangle rectangle2 = new Rectangle(rectangle);
                Dimension dimension = window.getMinimumSize();
                switch (this.dragCursor) {
                    case 11: {
                        SkinRootPaneUI.adjust(rectangle, dimension, 0, 0, point.x + (this.dragWidth - this.dragOffsetX) - rectangle.width, 0);
                        break;
                    }
                    case 9: {
                        SkinRootPaneUI.adjust(rectangle, dimension, 0, 0, 0, point.y + (this.dragHeight - this.dragOffsetY) - rectangle.height);
                        break;
                    }
                    case 8: {
                        SkinRootPaneUI.adjust(rectangle, dimension, 0, point.y - this.dragOffsetY, 0, -(point.y - this.dragOffsetY));
                        break;
                    }
                    case 10: {
                        SkinRootPaneUI.adjust(rectangle, dimension, point.x - this.dragOffsetX, 0, -(point.x - this.dragOffsetX), 0);
                        break;
                    }
                    case 7: {
                        SkinRootPaneUI.adjust(rectangle, dimension, 0, point.y - this.dragOffsetY, point.x + (this.dragWidth - this.dragOffsetX) - rectangle.width, -(point.y - this.dragOffsetY));
                        break;
                    }
                    case 5: {
                        SkinRootPaneUI.adjust(rectangle, dimension, 0, 0, point.x + (this.dragWidth - this.dragOffsetX) - rectangle.width, point.y + (this.dragHeight - this.dragOffsetY) - rectangle.height);
                        break;
                    }
                    case 6: {
                        SkinRootPaneUI.adjust(rectangle, dimension, point.x - this.dragOffsetX, point.y - this.dragOffsetY, -(point.x - this.dragOffsetX), -(point.y - this.dragOffsetY));
                        break;
                    }
                    case 4: {
                        SkinRootPaneUI.adjust(rectangle, dimension, point.x - this.dragOffsetX, 0, -(point.x - this.dragOffsetX), point.y + (this.dragHeight - this.dragOffsetY) - rectangle.height);
                        break;
                    }
                }
                if (!rectangle.equals(rectangle2) && SkinRootPaneUI.this.getFrameWindow().isResizable()) {
                    window.setBounds(rectangle);
                    if (Boolean.TRUE.equals(AccessUtils.invoke(Toolkit.getDefaultToolkit(), "isDynamicLayoutActive", null, null))) {
                        window.validate();
                        SkinRootPaneUI.this.getRootPane().repaint();
                    }
                    SkinRootPaneUI.this.getFrameWindow().dispatchEvent(new ComponentEvent(SkinRootPaneUI.this.getMainWindow(), 101));
                }
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            Window window = SkinRootPaneUI.translateSource(mouseEvent);
            SkinRootPaneUI.this.lastCursor = window.getCursor();
            this.mouseMoved(mouseEvent);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            Window window = SkinRootPaneUI.translateSource(mouseEvent);
            window.setCursor(SkinRootPaneUI.this.lastCursor);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Window window = SkinRootPaneUI.translateSource(mouseEvent);
            if (!(window instanceof Frame)) {
                return;
            }
            Frame frame = (Frame)window;
            Point point = SwingUtilities.convertPoint(window, mouseEvent.getPoint(), SkinRootPaneUI.this.getTitlePane());
            int n = SkinRootPaneUI.getExtendedState(frame);
            if (SkinRootPaneUI.this.getTitlePane() != null && SkinRootPaneUI.this.getTitlePane().contains(point) && mouseEvent.getClickCount() % 2 == 0 && (mouseEvent.getModifiers() & 0x10) != 0 && frame.isResizable()) {
                if ((n & Frame_MAXIMIZED_BOTH) != 0) {
                    SkinRootPaneUI.setExtendedState(frame, n & ~Frame_MAXIMIZED_BOTH);
                } else {
                    SkinRootPaneUI.setExtendedState(frame, n | Frame_MAXIMIZED_BOTH);
                }
                return;
            }
        }
    }

    private static class MetalRootLayout
    implements LayoutManager2 {
        private MetalRootLayout() {
        }

        public Dimension preferredLayoutSize(Container container) {
            Dimension dimension;
            JComponent jComponent;
            Dimension dimension2;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            Insets insets = container.getInsets();
            JRootPane jRootPane = (JRootPane)container;
            Dimension dimension3 = jRootPane.getContentPane() != null ? jRootPane.getContentPane().getPreferredSize() : jRootPane.getSize();
            if (dimension3 != null) {
                n = dimension3.width;
                n2 = dimension3.height;
            }
            if (jRootPane.getJMenuBar() != null && (dimension2 = jRootPane.getJMenuBar().getPreferredSize()) != null) {
                n3 = dimension2.width;
                n4 = dimension2.height;
            }
            if (SkinRootPaneUI.getWindowDecorationStyle(jRootPane) != JRootPane_NONE && jRootPane.getUI() instanceof SkinRootPaneUI && (jComponent = ((SkinRootPaneUI)jRootPane.getUI()).getTitlePane()) != null && (dimension = jComponent.getPreferredSize()) != null) {
                n5 = dimension.width;
                n6 = dimension.height;
            }
            return new Dimension(Math.max(Math.max(n, n3), n5) + insets.left + insets.right, n2 + n4 + n6 + insets.top + insets.bottom);
        }

        public Dimension minimumLayoutSize(Container container) {
            Dimension dimension;
            JComponent jComponent;
            Dimension dimension2;
            Dimension dimension3;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            Insets insets = container.getInsets();
            JRootPane jRootPane = (JRootPane)container;
            if (!(jRootPane.getParent() instanceof Window && SkinRootPaneUI.getWindowDecorationStyle(jRootPane) != JRootPane_NONE || (dimension3 = jRootPane.getContentPane() != null ? jRootPane.getContentPane().getMinimumSize() : jRootPane.getSize()) == null)) {
                n = dimension3.width;
                n2 = dimension3.height;
            }
            if (jRootPane.getJMenuBar() != null && (dimension2 = jRootPane.getJMenuBar().getMinimumSize()) != null) {
                n3 = dimension2.width;
                n4 = dimension2.height;
            }
            if (SkinRootPaneUI.getWindowDecorationStyle(jRootPane) != JRootPane_NONE && jRootPane.getUI() instanceof SkinRootPaneUI && (jComponent = ((SkinRootPaneUI)jRootPane.getUI()).getTitlePane()) != null && (dimension = jComponent.getMinimumSize()) != null) {
                n5 = dimension.width;
                n6 = dimension.height;
            }
            return new Dimension(Math.max(Math.max(n, n3), n5) + insets.left + insets.right, n2 + n4 + n6 + insets.top + insets.bottom);
        }

        public Dimension maximumLayoutSize(Container container) {
            int n;
            int n2;
            Dimension dimension;
            JComponent jComponent;
            Dimension dimension2;
            Dimension dimension3;
            int n3 = Integer.MAX_VALUE;
            int n4 = Integer.MAX_VALUE;
            int n5 = Integer.MAX_VALUE;
            int n6 = Integer.MAX_VALUE;
            int n7 = Integer.MAX_VALUE;
            int n8 = Integer.MAX_VALUE;
            Insets insets = container.getInsets();
            JRootPane jRootPane = (JRootPane)container;
            if (jRootPane.getContentPane() != null && (dimension3 = jRootPane.getContentPane().getMaximumSize()) != null) {
                n3 = dimension3.width;
                n4 = dimension3.height;
            }
            if (jRootPane.getJMenuBar() != null && (dimension2 = jRootPane.getJMenuBar().getMaximumSize()) != null) {
                n5 = dimension2.width;
                n6 = dimension2.height;
            }
            if (SkinRootPaneUI.getWindowDecorationStyle(jRootPane) != JRootPane_NONE && jRootPane.getUI() instanceof SkinRootPaneUI && (jComponent = ((SkinRootPaneUI)jRootPane.getUI()).getTitlePane()) != null && (dimension = jComponent.getMaximumSize()) != null) {
                n7 = dimension.width;
                n8 = dimension.height;
            }
            if ((n2 = Math.max(Math.max(n4, n6), n8)) != Integer.MAX_VALUE) {
                n2 = n4 + n6 + n8 + insets.top + insets.bottom;
            }
            if ((n = Math.max(Math.max(n3, n5), n7)) != Integer.MAX_VALUE) {
                n += insets.left + insets.right;
            }
            return new Dimension(n, n2);
        }

        public void layoutContainer(Container container) {
            Dimension dimension;
            Serializable serializable;
            JRootPane jRootPane = (JRootPane)container;
            Rectangle rectangle = jRootPane.getBounds();
            Insets insets = jRootPane.getInsets();
            int n = 0;
            int n2 = rectangle.width - insets.right - insets.left;
            int n3 = rectangle.height - insets.top - insets.bottom;
            if (jRootPane.getLayeredPane() != null) {
                jRootPane.getLayeredPane().setBounds(insets.left, insets.top, n2, n3);
            }
            if (jRootPane.getGlassPane() != null) {
                jRootPane.getGlassPane().setBounds(insets.left, insets.top, n2, n3);
            }
            if (SkinRootPaneUI.getWindowDecorationStyle(jRootPane) != JRootPane_NONE && jRootPane.getUI() instanceof SkinRootPaneUI && (serializable = ((SkinRootPaneUI)jRootPane.getUI()).getTitlePane()) != null && (dimension = ((JComponent)serializable).getPreferredSize()) != null) {
                int n4 = dimension.height;
                ((Component)serializable).setBounds(0, 0, n2, n4);
                n += n4;
            }
            if (jRootPane.getJMenuBar() != null) {
                serializable = jRootPane.getJMenuBar().getPreferredSize();
                jRootPane.getJMenuBar().setBounds(0, n, n2, ((Dimension)serializable).height);
                n += ((Dimension)serializable).height;
            }
            if (jRootPane.getContentPane() != null) {
                serializable = jRootPane.getContentPane().getPreferredSize();
                jRootPane.getContentPane().setBounds(0, n, n2, n3 < n ? 0 : n3 - n);
            }
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public void addLayoutComponent(Component component, Object object) {
        }

        public float getLayoutAlignmentX(Container container) {
            return 0.0f;
        }

        public float getLayoutAlignmentY(Container container) {
            return 0.0f;
        }

        public void invalidateLayout(Container container) {
        }
    }
}

