/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.contrib.nanoxml;

import com.l2fprod.contrib.nanoxml.XMLParseException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class XMLElement
implements Serializable {
    private Properties attributes;
    private Vector children;
    private String tagName;
    private String contents;
    private Properties conversionTable;
    private boolean skipLeadingWhitespace;
    private int lineNr;
    private boolean ignoreCase;
    public static final int NANOXML_MAJOR_VERSION = 1;
    public static final int NANOXML_MINOR_VERSION = 6;
    static final long serialVersionUID = 6685035139346394777L;

    public XMLElement() {
        this(new Properties(), false, true, true);
    }

    public XMLElement(Properties properties) {
        this(properties, false, true, true);
    }

    public XMLElement(boolean bl) {
        this(new Properties(), bl, true, true);
    }

    public XMLElement(Properties properties, boolean bl) {
        this(properties, bl, true, true);
    }

    public XMLElement(Properties properties, boolean bl, boolean bl2) {
        this(properties, bl, true, bl2);
    }

    protected XMLElement(Properties properties, boolean bl, boolean bl2, boolean bl3) {
        this.ignoreCase = bl3;
        this.skipLeadingWhitespace = bl;
        this.tagName = null;
        this.contents = "";
        this.attributes = new Properties();
        this.children = new Vector();
        this.conversionTable = properties;
        this.lineNr = 0;
        if (bl2) {
            this.conversionTable.put("lt", "<");
            this.conversionTable.put("gt", ">");
            this.conversionTable.put("quot", "\"");
            this.conversionTable.put("apos", "'");
            this.conversionTable.put("amp", "&");
        }
    }

    public void setContent(String string) {
        this.contents = string;
    }

    public void setTagName(String string) {
        this.tagName = string;
    }

    public Vector getChildren() {
        return this.children;
    }

    public String getContents() {
        return this.contents;
    }

    public int getLineNr() {
        return this.lineNr;
    }

    public int getIntProperty(String string, Hashtable hashtable, String string2) {
        Integer n;
        String string3 = this.attributes.getProperty(string);
        if (this.ignoreCase) {
            string = string.toUpperCase();
        }
        if (string3 == null) {
            string3 = string2;
        }
        try {
            n = (Integer)hashtable.get(string3);
        }
        catch (ClassCastException classCastException) {
            throw this.invalidValueSet(string);
        }
        if (n == null) {
            throw this.invalidValue(string, string3, this.lineNr);
        }
        return n;
    }

    public String getProperty(String string) {
        if (this.ignoreCase) {
            string = string.toUpperCase();
        }
        return this.attributes.getProperty(string);
    }

    public String getProperty(String string, String string2) {
        if (this.ignoreCase) {
            string = string.toUpperCase();
        }
        return this.attributes.getProperty(string, string2);
    }

    public int getProperty(String string, int n) {
        String string2;
        if (this.ignoreCase) {
            string = string.toUpperCase();
        }
        if ((string2 = this.attributes.getProperty(string)) == null) {
            return n;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw this.invalidValue(string, string2, this.lineNr);
        }
    }

    public double getProperty(String string, double d) {
        String string2;
        if (this.ignoreCase) {
            string = string.toUpperCase();
        }
        if ((string2 = this.attributes.getProperty(string)) == null) {
            return d;
        }
        try {
            return Double.valueOf(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw this.invalidValue(string, string2, this.lineNr);
        }
    }

    public boolean getProperty(String string, String string2, String string3, boolean bl) {
        String string4;
        if (this.ignoreCase) {
            string = string.toUpperCase();
        }
        if ((string4 = this.attributes.getProperty(string)) == null) {
            return bl;
        }
        if (string4.equals(string2)) {
            return true;
        }
        if (string4.equals(string3)) {
            return false;
        }
        throw this.invalidValue(string, string4, this.lineNr);
    }

    public Object getProperty(String string, Hashtable hashtable, String string2) {
        Object v;
        String string3;
        if (this.ignoreCase) {
            string = string.toUpperCase();
        }
        if ((string3 = this.attributes.getProperty(string)) == null) {
            string3 = string2;
        }
        if ((v = hashtable.get(string3)) == null) {
            throw this.invalidValue(string, string3, this.lineNr);
        }
        return v;
    }

    public String getStringProperty(String string, Hashtable hashtable, String string2) {
        String string3;
        String string4;
        if (this.ignoreCase) {
            string = string.toUpperCase();
        }
        if ((string4 = this.attributes.getProperty(string)) == null) {
            string4 = string2;
        }
        try {
            string3 = (String)hashtable.get(string4);
        }
        catch (ClassCastException classCastException) {
            throw this.invalidValueSet(string);
        }
        if (string3 == null) {
            throw this.invalidValue(string, string4, this.lineNr);
        }
        return string3;
    }

    public int getSpecialIntProperty(String string, Hashtable hashtable, String string2) {
        Integer n;
        String string3;
        if (this.ignoreCase) {
            string = string.toUpperCase();
        }
        if ((string3 = this.attributes.getProperty(string)) == null) {
            string3 = string2;
        }
        try {
            n = (Integer)hashtable.get(string3);
        }
        catch (ClassCastException classCastException) {
            throw this.invalidValueSet(string);
        }
        if (n == null) {
            try {
                return Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                throw this.invalidValue(string, string3, this.lineNr);
            }
        }
        return n;
    }

    public double getSpecialDoubleProperty(String string, Hashtable hashtable, String string2) {
        Double d;
        String string3;
        if (this.ignoreCase) {
            string = string.toUpperCase();
        }
        if ((string3 = this.attributes.getProperty(string)) == null) {
            string3 = string2;
        }
        try {
            d = (Double)hashtable.get(string3);
        }
        catch (ClassCastException classCastException) {
            throw this.invalidValueSet(string);
        }
        if (d == null) {
            try {
                d = Double.valueOf(string3);
            }
            catch (NumberFormatException numberFormatException) {
                throw this.invalidValue(string, string3, this.lineNr);
            }
        }
        return d;
    }

    public String getTagName() {
        return this.tagName;
    }

    public void addChild(XMLElement xMLElement) {
        this.children.addElement(xMLElement);
    }

    public void addProperty(String string, Object object) {
        if (this.ignoreCase) {
            string = string.toUpperCase();
        }
        this.attributes.put(string, object.toString());
    }

    public void addProperty(String string, int n) {
        if (this.ignoreCase) {
            string = string.toUpperCase();
        }
        this.attributes.put(string, Integer.toString(n));
    }

    public void addProperty(String string, double d) {
        if (this.ignoreCase) {
            string = string.toUpperCase();
        }
        this.attributes.put(string, Double.toString(d));
    }

    public int countChildren() {
        return this.children.size();
    }

    public Enumeration enumeratePropertyNames() {
        return this.attributes.keys();
    }

    public Enumeration enumerateChildren() {
        return this.children.elements();
    }

    public void parseFromReader(Reader reader) throws IOException, XMLParseException {
        this.parseFromReader(reader, 1);
    }

    public void parseFromReader(Reader reader, int n) throws IOException, XMLParseException {
        int n2 = 4096;
        char[] cArray = null;
        int n3 = 0;
        while (true) {
            if (cArray == null) {
                cArray = new char[n2];
            } else {
                char[] cArray2 = cArray;
                cArray = new char[cArray.length + n2];
                System.arraycopy(cArray2, 0, cArray, 0, cArray2.length);
            }
            int n4 = reader.read(cArray, n3, n2);
            if (n4 < 0) break;
            n3 += n4;
        }
        this.parseCharArray(cArray, 0, n3, n);
    }

    public void parseString(String string) throws XMLParseException {
        this.parseCharArray(string.toCharArray(), 0, string.length(), 1);
    }

    public int parseString(String string, int n) throws XMLParseException {
        return this.parseCharArray(string.toCharArray(), n, string.length(), 1);
    }

    public int parseString(String string, int n, int n2) throws XMLParseException {
        return this.parseCharArray(string.toCharArray(), n, n2, 1);
    }

    public int parseString(String string, int n, int n2, int n3) throws XMLParseException {
        return this.parseCharArray(string.toCharArray(), n, n2, n3);
    }

    public int parseCharArray(char[] cArray, int n, int n2) throws XMLParseException {
        return this.parseCharArray(cArray, n, n2, 1);
    }

    public int parseCharArray(char[] cArray, int n, int n2, int n3) throws XMLParseException {
        int[] nArray = new int[]{n3};
        return this.parseCharArray(cArray, n, n2, nArray);
    }

    public void removeChild(XMLElement xMLElement) {
        this.children.removeElement(xMLElement);
    }

    public void removeChild(String string) {
        if (this.ignoreCase) {
            string = string.toUpperCase();
        }
        this.attributes.remove(string);
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        this.write(stringWriter);
        return stringWriter.toString();
    }

    public void write(Writer writer) {
        this.write(writer, 0);
    }

    public void write(Writer writer, int n) {
        Object object;
        int n2;
        PrintWriter printWriter = new PrintWriter(writer);
        for (n2 = 0; n2 < n; ++n2) {
            printWriter.print(' ');
        }
        if (this.tagName == null) {
            this.writeEncoded(printWriter, this.contents);
            return;
        }
        printWriter.print('<');
        printWriter.print(this.tagName);
        if (!this.attributes.isEmpty()) {
            Enumeration<Object> enumeration = this.attributes.keys();
            while (enumeration.hasMoreElements()) {
                printWriter.print(' ');
                object = (String)enumeration.nextElement();
                String string = (String)this.attributes.get(object);
                printWriter.print((String)object);
                printWriter.print("=\"");
                this.writeEncoded(printWriter, string);
                printWriter.print('\"');
            }
        }
        if (this.contents != null && this.contents.length() > 0) {
            if (this.skipLeadingWhitespace) {
                printWriter.println('>');
                for (n2 = 0; n2 < n + 4; ++n2) {
                    printWriter.print(' ');
                }
                printWriter.println(this.contents);
                for (n2 = 0; n2 < n; ++n2) {
                    printWriter.print(' ');
                }
            } else {
                printWriter.print('>');
                this.writeEncoded(printWriter, this.contents);
            }
            printWriter.print("</");
            printWriter.print(this.tagName);
            printWriter.println('>');
        } else if (this.children.isEmpty()) {
            printWriter.println("/>");
        } else {
            printWriter.println('>');
            Enumeration enumeration = this.enumerateChildren();
            while (enumeration.hasMoreElements()) {
                object = (XMLElement)enumeration.nextElement();
                ((XMLElement)object).write(writer, n + 4);
            }
            for (int i = 0; i < n; ++i) {
                printWriter.print(' ');
            }
            printWriter.print("</");
            printWriter.print(this.tagName);
            printWriter.println('>');
        }
    }

    protected void scanChildren(char[] cArray, int n, int n2, int n3) throws XMLParseException {
        int n4 = n + n2;
        int n5 = n;
        int[] nArray = new int[]{n3};
        while (n5 < n4) {
            try {
                n5 = this.skipWhitespace(cArray, n5, n4, nArray);
            }
            catch (XMLParseException xMLParseException) {
                return;
            }
            if (cArray[n5] != '<' || cArray[n5 + 1] == '!' && cArray[n5 + 2] == '[') {
                return;
            }
            XMLElement xMLElement = this.createAnotherElement();
            n5 = xMLElement.parseCharArray(cArray, n5, n4, nArray);
            this.children.addElement(xMLElement);
        }
    }

    protected XMLElement createAnotherElement() {
        return new XMLElement(this.conversionTable, this.skipLeadingWhitespace, false, this.ignoreCase);
    }

    protected int skipBogusTag(char[] cArray, int n, int n2, int[] nArray) {
        int n3 = 1;
        block6: while (n < n2) {
            char c = cArray[n++];
            switch (c) {
                case '\r': {
                    if (n < n2 && cArray[n] == '\n') {
                        ++n;
                    }
                    nArray[0] = nArray[0] + 1;
                    continue block6;
                }
                case '\n': {
                    nArray[0] = nArray[0] + 1;
                    continue block6;
                }
                case '<': {
                    ++n3;
                    continue block6;
                }
                case '>': {
                    if (--n3 != 0) continue block6;
                    return n;
                }
            }
        }
        throw this.unexpectedEndOfData(nArray[0]);
    }

    protected String decodeString(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i = 0; i < string.length(); ++i) {
            int n2;
            int n3 = (string + '&').indexOf(38, i);
            if (n3 <= (n2 = (string + "<![CDATA[").indexOf("<![CDATA[", i))) {
                stringBuffer.append(string.substring(i, n3));
                if (n3 == string.length()) break;
                i = string.indexOf(59, n3);
                if (i < 0) {
                    stringBuffer.append(string.substring(n3));
                    break;
                }
                String string2 = string.substring(n3 + 1, i);
                if (string2.charAt(0) == '#') {
                    if (string2.charAt(1) == 'x') {
                        stringBuffer.append((char)Integer.parseInt(string2.substring(2), 16));
                        continue;
                    }
                    stringBuffer.append((char)Integer.parseInt(string2.substring(1), 10));
                    continue;
                }
                stringBuffer.append(this.conversionTable.getProperty(string2, "&" + string2 + ';'));
                continue;
            }
            int n4 = (string + "]]>").indexOf("]]>", n2 + 9);
            stringBuffer.append(string.substring(i, n2));
            stringBuffer.append(string.substring(n2 + 9, n4));
            i = n4 + 2;
        }
        return stringBuffer.toString();
    }

    protected void writeEncoded(PrintWriter printWriter, String string) {
        block8: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    printWriter.write("&lt;");
                    continue block8;
                }
                case '>': {
                    printWriter.write("&gt;");
                    continue block8;
                }
                case '&': {
                    printWriter.write("&amp;");
                    continue block8;
                }
                case '\"': {
                    printWriter.write("&quot;");
                    continue block8;
                }
                case '\'': {
                    printWriter.write("&apos;");
                    continue block8;
                }
                case '\n': 
                case '\r': {
                    printWriter.write(c);
                    continue block8;
                }
                default: {
                    if (c < ' ' || c > '~') {
                        printWriter.write("&#x");
                        printWriter.write(Integer.toString(c, 16));
                        printWriter.write(59);
                        continue block8;
                    }
                    printWriter.write(c);
                }
            }
        }
    }

    private boolean isIdentifierChar(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || ".-_:".indexOf(c) >= 0;
    }

    private int parseCharArray(char[] cArray, int n, int n2, int[] nArray) throws XMLParseException {
        this.lineNr = nArray[0];
        this.tagName = null;
        this.contents = null;
        this.attributes = new Properties();
        this.children = new Vector();
        try {
            n = this.skipWhitespace(cArray, n, n2, nArray);
        }
        catch (XMLParseException xMLParseException) {
            return n;
        }
        n = this.skipPreamble(cArray, n, n2, nArray);
        n = this.scanTagName(cArray, n, n2, nArray);
        this.lineNr = nArray[0];
        n = this.scanAttributes(cArray, n, n2, nArray);
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        int n3 = nArray[0];
        n = this.scanContent(cArray, n, n2, nArray2, nArray3, nArray);
        if (nArray3[0] > 0) {
            this.scanChildren(cArray, nArray2[0], nArray3[0], n3);
            if (this.children.size() > 0) {
                this.contents = null;
            } else {
                this.processContents(cArray, nArray2[0], nArray3[0], n3);
                for (int i = 0; i < nArray3[0]; ++i) {
                    if (cArray[nArray2[0] + i] <= ' ') continue;
                    return n;
                }
                this.contents = null;
            }
        }
        return n;
    }

    private void processContents(char[] cArray, int n, int n2, int n3) throws XMLParseException {
        int[] nArray = new int[]{n3};
        if (!this.skipLeadingWhitespace) {
            String string = new String(cArray, n, n2);
            this.contents = this.decodeString(string, nArray[0]);
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(n2);
        int n4 = n2 + n;
        for (int i = n; i < n4; ++i) {
            char c = cArray[i];
            while (c == '\r' || c == '\n') {
                nArray[0] = nArray[0] + 1;
                stringBuffer.append(c);
                c = cArray[++i];
                if (c != '\n') {
                    stringBuffer.append(c);
                }
                while ((c = cArray[++i]) == ' ' || c == '\t') {
                }
            }
            if (i >= n4) continue;
            stringBuffer.append(c);
        }
        this.contents = this.decodeString(stringBuffer.toString(), nArray[0]);
    }

    private int scanAttributes(char[] cArray, int n, int n2, int[] nArray) throws XMLParseException {
        char c;
        while ((c = cArray[n = this.skipWhitespace(cArray, n, n2, nArray)]) != '/' && c != '>') {
            n = this.scanOneAttribute(cArray, n, n2, nArray);
        }
        return n;
    }

    private int scanContent(char[] cArray, int n, int n2, int[] nArray, int[] nArray2, int[] nArray3) throws XMLParseException {
        int n3;
        if (cArray[n] == '/') {
            nArray2[0] = 0;
            if (cArray[n + 1] != '>') {
                throw this.expectedInput("'>'", nArray3[0]);
            }
            return n + 2;
        }
        if (cArray[n] != '>') {
            throw this.expectedInput("'>'", nArray3[0]);
        }
        if (this.skipLeadingWhitespace) {
            n = this.skipWhitespace(cArray, n + 1, n2, nArray3);
        }
        nArray[0] = ++n;
        int n4 = 0;
        char[] cArray2 = this.tagName.toCharArray();
        n2 -= cArray2.length + 2;
        while (n < n2 && n4 >= 0) {
            if (cArray[n] == '<') {
                int n5;
                n3 = 1;
                if (n < n2 - 1 && cArray[n + 1] == '!' && cArray[n + 2] == '[') {
                    ++n;
                    continue;
                }
                for (n5 = 0; n3 != 0 && n5 < cArray2.length; n3 &= cArray[n + (n5 + 1)] == cArray2[n5] ? 1 : 0, ++n5) {
                }
                if ((n3 &= !this.isIdentifierChar(cArray[n + cArray2.length + 1]) ? 1 : 0) != 0) {
                    while (n < n2 && cArray[n] != '>') {
                        ++n;
                    }
                    if (cArray[n - 1] == '/') continue;
                    ++n4;
                    continue;
                }
                if (cArray[n + 1] == '/') {
                    n3 = 1;
                    for (n5 = 0; n3 != 0 && n5 < cArray2.length; n3 &= cArray[n + (n5 + 2)] == cArray2[n5] ? 1 : 0, ++n5) {
                    }
                    if (n3 != 0) {
                        nArray2[0] = n - nArray[0];
                        n += cArray2.length + 2;
                        try {
                            n = this.skipWhitespace(cArray, n, n2 + cArray2.length + 2, nArray3);
                        }
                        catch (XMLParseException xMLParseException) {
                            // empty catch block
                        }
                        if (cArray[n] != '>') continue;
                        --n4;
                        ++n;
                        continue;
                    }
                }
            }
            if (cArray[n] == '\r') {
                nArray3[0] = nArray3[0] + 1;
                if (n != n2 && cArray[n + 1] == '\n') {
                    ++n;
                }
            } else if (cArray[n] == '\n') {
                nArray3[0] = nArray3[0] + 1;
            }
            ++n;
        }
        if (n4 >= 0) {
            throw this.unexpectedEndOfData(nArray3[0]);
        }
        if (this.skipLeadingWhitespace) {
            n3 = nArray[0] + nArray2[0] - 1;
            while (nArray2[0] >= 0 && cArray[n3] <= ' ') {
                --n3;
                nArray2[0] = nArray2[0] - 1;
            }
        }
        return n;
    }

    private String scanIdentifier(char[] cArray, int n, int n2) {
        int n3 = n;
        while (n < n2 && this.isIdentifierChar(cArray[n])) {
            ++n;
        }
        if (n == n2 || n == n3) {
            return null;
        }
        return new String(cArray, n3, n - n3);
    }

    private int scanOneAttribute(char[] cArray, int n, int n2, int[] nArray) throws XMLParseException {
        String string = this.scanIdentifier(cArray, n, n2);
        if (string == null) {
            throw this.syntaxError("an attribute key", nArray[0]);
        }
        n = this.skipWhitespace(cArray, n + string.length(), n2, nArray);
        if (this.ignoreCase) {
            string = string.toUpperCase();
        }
        if (cArray[n] != '=') {
            throw this.valueMissingForAttribute(string, nArray[0]);
        }
        String string2 = this.scanString(cArray, n = this.skipWhitespace(cArray, n + 1, n2, nArray), n2, nArray);
        if (string2 == null) {
            throw this.syntaxError("an attribute value", nArray[0]);
        }
        if (string2.charAt(0) == '\"' || string2.charAt(0) == '\'') {
            string2 = string2.substring(1, string2.length() - 1);
            n += 2;
        }
        this.attributes.put(string, this.decodeString(string2, nArray[0]));
        return n + string2.length();
    }

    private String scanString(char[] cArray, int n, int n2, int[] nArray) throws XMLParseException {
        char c = cArray[n];
        if (c == '\"' || c == '\'') {
            int n3 = n++;
            while (n < n2 && cArray[n] != c) {
                if (cArray[n] == '\r') {
                    nArray[0] = nArray[0] + 1;
                    if (n != n2 && cArray[n + 1] == '\n') {
                        ++n;
                    }
                } else if (cArray[n] == '\n') {
                    nArray[0] = nArray[0] + 1;
                }
                ++n;
            }
            if (n == n2) {
                return null;
            }
            return new String(cArray, n3, n - n3 + 1);
        }
        return this.scanIdentifier(cArray, n, n2);
    }

    private int scanTagName(char[] cArray, int n, int n2, int[] nArray) throws XMLParseException {
        this.tagName = this.scanIdentifier(cArray, n, n2);
        if (this.tagName == null) {
            throw this.syntaxError("a tag name", nArray[0]);
        }
        return n + this.tagName.length();
    }

    private int skipPreamble(char[] cArray, int n, int n2, int[] nArray) throws XMLParseException {
        char c;
        do {
            if (cArray[n = this.skipWhitespace(cArray, n, n2, nArray)] != '<') {
                this.expectedInput("'<'", nArray[0]);
            }
            if (++n >= n2) {
                throw this.unexpectedEndOfData(nArray[0]);
            }
            c = cArray[n];
            if (c != '!' && c != '?') continue;
            n = this.skipBogusTag(cArray, n, n2, nArray);
        } while (!this.isIdentifierChar(c));
        return n;
    }

    private int skipWhitespace(char[] cArray, int n, int n2, int[] nArray) {
        int n3 = nArray[0];
        while (n < n2) {
            if (n + 6 < n2 && cArray[n + 3] == '-' && cArray[n + 2] == '-' && cArray[n + 1] == '!' && cArray[n] == '<') {
                n += 4;
                while (cArray[n] != '-' || cArray[n + 1] != '-' || cArray[n + 2] != '>') {
                    if (n + 2 >= n2) {
                        throw this.unexpectedEndOfData(n3);
                    }
                    ++n;
                }
                n += 3;
            } else if (cArray[n] == '\r') {
                nArray[0] = nArray[0] + 1;
                if (n != n2 && cArray[n + 1] == '\n') {
                    ++n;
                }
            } else if (cArray[n] == '\n') {
                nArray[0] = nArray[0] + 1;
            } else if (cArray[n] > ' ') break;
            ++n;
        }
        if (n == n2) {
            throw this.unexpectedEndOfData(n3);
        }
        return n;
    }

    private XMLParseException invalidValueSet(String string) {
        String string2 = "Invalid value set (key = \"" + string + "\")";
        return new XMLParseException(this.getTagName(), string2);
    }

    private XMLParseException invalidValue(String string, String string2, int n) {
        String string3 = "Attribute \"" + string + "\" does not contain a valid " + "value (\"" + string2 + "\")";
        return new XMLParseException(this.getTagName(), n, string3);
    }

    private XMLParseException unexpectedEndOfData(int n) {
        String string = "Unexpected end of data reached";
        return new XMLParseException(this.getTagName(), n, string);
    }

    private XMLParseException syntaxError(String string, int n) {
        String string2 = "Syntax error while parsing " + string;
        return new XMLParseException(this.getTagName(), n, string2);
    }

    private XMLParseException expectedInput(String string, int n) {
        String string2 = "Expected: " + string;
        return new XMLParseException(this.getTagName(), n, string2);
    }

    private XMLParseException valueMissingForAttribute(String string, int n) {
        String string2 = "Value missing for attribute with key \"" + string + "\"";
        return new XMLParseException(this.getTagName(), n, string2);
    }
}

