/*

  Copyright (C) 2004-2005 Smardec. All rights reserved.

  http://www.smardec.com

*/

package com.smardec.jndi.mirror;

import javax.naming.Context;
import javax.naming.spi.InitialContextFactory;
import java.beans.XMLDecoder;
import java.io.*;
import java.util.Hashtable;


/**
 * <code>InitialContextFactory</code> implementation.
 */
public class MirrorInitialCtxFactory implements InitialContextFactory {
    /**
     * Creates <code>MirrorInitialCtxFactory</code> object.
     */
    public MirrorInitialCtxFactory() {}

    /**
     * Creates an Initial Context for beginning name resolution.
     * It reads <code>Context.PROVIDER_URL</code> from the <code>env</code> and performs the following operations:
     * <br>1) if the value of the <code>Context.PROVIDER_URL</code> ends with '.xml'
     * it tries to load the xml file with xml-serialized context.
     * <br>2) if the value of the <code>Context.PROVIDER_URL</code> not ends with '.xml'
     * it tries to load the binary file with serialized context.
     * <br>3) if the first and the second steps failed it creates new <code>MirrorCtx</code> object.
     * <p/>
     * The environment parameter is owned by the caller.
     * The implementation will not modify the object or keep a reference
     * to it, although it may keep a reference to a clone or copy.
     *
     * @param env The possibly <code>null</code> environment specifying information
     *            to be used in the creation of the initial context.
     * @return A non-<code>null</code> initial context object that implements the Context interface.
     */
    public Context getInitialContext(Hashtable env) {
        String providerURL = null;
        if (env != null)
            providerURL = (String) env.get(Context.PROVIDER_URL);
        MirrorCtx mirrorCtx = null;
        try {
            if (providerURL.endsWith(".xml")) {
                XMLDecoder xmldecoder = null;
                try {
                    BufferedInputStream input = new BufferedInputStream(new FileInputStream(new File(providerURL)));
                    xmldecoder = new XMLDecoder(input);
                    return (Context) xmldecoder.readObject();
                } catch (IOException ioexception) {
                } finally {
                    if (xmldecoder != null)
                        xmldecoder.close();
                }
            }
            ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(new File(providerURL)));
            mirrorCtx = (MirrorCtx) objectInputStream.readObject();
        } catch (Exception e) {}
        if (mirrorCtx == null)
            mirrorCtx = new MirrorCtx(env);
        return mirrorCtx;
    }
}
