/*
 * Decompiled with CFR 0.152.
 */
package com.smardec.jndi.mirror.samples;

import com.smardec.jndi.mirror.samples.CopySaveLoadSample;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;

public class BasicOperationsSample {
    public static void main(String[] args) {
        block6: {
            try {
                Context loadedContext;
                Hashtable<String, String> environment = new Hashtable<String, String>();
                environment.put("java.naming.factory.initial", "com.smardec.jndi.mirror.MirrorInitialCtxFactory");
                InitialContext mirrorCtx = new InitialContext(environment);
                Context a = mirrorCtx.createSubcontext("a");
                Context b = a.createSubcontext("b");
                Context c = b.createSubcontext("c");
                c.bind("date", (Object)new Date());
                System.out.println("Date: " + mirrorCtx.lookup("a.b.c.date"));
                if (args.length > 0 && "binary".equals(args[0])) {
                    System.out.println("Saving to file 'basic.dat'");
                    ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream("basic.dat"));
                    objectOutputStream.writeObject(mirrorCtx.lookup(""));
                    objectOutputStream.close();
                } else {
                    System.out.println("Saving to file 'basic.xml'");
                    FileOutputStream fileOutputStream = new FileOutputStream("basic.xml");
                    fileOutputStream.write(mirrorCtx.lookup("").toString().getBytes());
                    fileOutputStream.close();
                }
                mirrorCtx.close();
                if (args.length > 0 && "binary".equals(args[0])) {
                    System.out.println("Loading file 'basic.dat'");
                    loadedContext = CopySaveLoadSample.loadContextFromFile("basic.dat");
                    System.out.println("Loaded date: " + loadedContext.lookup("a.b.c.date"));
                    loadedContext.close();
                    break block6;
                }
                System.out.println("Loading file 'basic.xml'");
                loadedContext = CopySaveLoadSample.loadContextFromFile("basic.xml");
                System.out.println("Loaded date: " + loadedContext.lookup("a.b.c.date"));
                loadedContext.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            catch (NoClassDefFoundError error) {
                System.out.println("JDK1.4 or higher is required for XML serialization\nUse 'binary' command line parameter");
            }
        }
    }
}

