/*
 * Decompiled with CFR 0.152.
 */
package com.smardec.j2native;

import com.smardec.j2native.Argument;
import com.smardec.j2native.J2NativeContext;
import com.smardec.j2native.MemoryException;
import com.smardec.j2native.PointerType;
import com.smardec.j2native.g;

public abstract class PointerArgument
extends Argument
implements PointerType {
    public int getLength() {
        return J2NativeContext.getPointerLength();
    }

    protected void writeToStack(byte[] byArray, int n) {
        this.toBytesValue(byArray, n);
    }

    protected void readFromStack(byte[] byArray, int n) {
        this.fromBytesValue(byArray, n);
    }

    public byte[] toBytesValue() {
        byte[] byArray = new byte[this.getLength()];
        this.toBytesValue(byArray, 0);
        return byArray;
    }

    public void toBytesValue(byte[] byArray, int n) {
        int n2 = this.getLength();
        long l = this.getValue();
        int n3 = 0;
        while (n3 < n2) {
            byArray[n3 + n] = (byte)(l % 256L);
            l >>>= 8;
            ++n3;
        }
    }

    public void fromBytesValue(byte[] byArray, int n) {
        int n2 = Math.min(byArray.length - n, this.getLength());
        long l = 0L;
        int n3 = n2 + n - 1;
        while (n3 >= n) {
            l <<= 8;
            l |= (long)(byArray[n3] & 0xFF);
            --n3;
        }
        this.setValue(l);
    }

    public boolean equals(Object object) {
        if (this.getClass().equals(object.getClass())) {
            return this.hashCode() == object.hashCode();
        }
        return false;
    }

    public int hashCode() {
        return (int)this.getValue();
    }

    protected void write(long l, int n) throws MemoryException {
        g.getInstance().writePointer(l, n, this.getValue());
    }

    protected void read(long l, int n) throws MemoryException {
        this.setValue(g.getInstance().readPointer(l, n));
    }

    protected boolean isFixedLength() {
        return true;
    }
}

