/*
 * Decompiled with CFR 0.152.
 */
package com.smardec.j2native;

import com.smardec.j2native.Argument;
import com.smardec.j2native.Function;
import com.smardec.j2native.J2NativeContext;
import com.smardec.j2native.MemoryException;
import com.smardec.j2native.c;
import com.smardec.j2native.g;

public abstract class Callback
extends Argument {
    private byte callingConvention;
    private long thunkAddress;
    private Argument returnArgument;
    private Argument[] arguments;

    protected Callback() {
        this.setCallingConvention(Function.DEFAULT_CALLING_CONVENTION);
    }

    protected Callback(Argument argument, Argument[] argumentArray) {
        this.setCallingConvention(Function.DEFAULT_CALLING_CONVENTION);
        this.initialize(argument, argumentArray);
    }

    public byte getCallingConvention() {
        return this.callingConvention;
    }

    protected void setCallingConvention(byte by) {
        this.callingConvention = by;
    }

    protected void initialize(Argument argument, Argument[] argumentArray) {
        this.arguments = argumentArray;
        this.returnArgument = argument;
    }

    protected Argument[] getArguments() {
        return this.arguments;
    }

    protected Argument getReturnArgument() {
        return this.returnArgument;
    }

    public void dispose() {
        if (this.getThunkAddress() != 0L) {
            Callback.destroyThunk(this.getThunkAddress());
            this.setThunkAddress(0L);
        }
    }

    public String toString() {
        return Long.toHexString(this.getThunkAddress());
    }

    public abstract void callback();

    public int getLength() {
        return J2NativeContext.getPointerLength();
    }

    protected void writeToStack(byte[] byArray, int n) {
        this.update((byte)2);
        this.toBytesValue(byArray, n);
    }

    protected void readFromStack(byte[] byArray, int n) {
    }

    public byte[] toBytesValue() {
        byte[] byArray = new byte[this.getLength()];
        this.toBytesValue(byArray, 0);
        return byArray;
    }

    protected void toBytesValue(byte[] byArray, int n) {
        int n2 = this.getLength();
        long l = this.getThunkAddress();
        int n3 = 0;
        while (n3 < n2) {
            byArray[n3 + n] = (byte)(l % 256L);
            l >>>= 8;
            ++n3;
        }
    }

    public void fromBytesValue(byte[] byArray, int n) {
    }

    public boolean equals(Object object) {
        if (this.getClass().equals(object.getClass())) {
            return this.hashCode() == object.hashCode();
        }
        return false;
    }

    public int hashCode() {
        return (int)this.getThunkAddress();
    }

    public Object clone() {
        throw new UnsupportedOperationException();
    }

    protected void write(long l, int n) throws MemoryException {
        this.update((byte)2);
        g.getInstance().writePointer(l, n, this.getThunkAddress());
    }

    protected void read(long l, int n) {
    }

    protected boolean isFixedLength() {
        return true;
    }

    private long getThunkAddress() {
        return this.thunkAddress;
    }

    private void setThunkAddress(long l) {
        this.thunkAddress = l;
    }

    protected void update(byte by) {
        switch (by) {
            case 2: {
                if (this.getThunkAddress() != 0L) break;
                this.setThunkAddress(this.createThunk(this.getCallingConvention(), this.getArgumentsLength()));
                break;
            }
        }
    }

    private long entryPoint(long l) {
        c c2 = null;
        Argument[] argumentArray = this.getArguments();
        if (argumentArray != null && argumentArray.length != 0) {
            c2 = new c(g.getInstance().readByteArray(l, 0, this.getArgumentsLength()), this.getCallingConvention());
            int n = argumentArray.length - 1;
            while (n >= 0) {
                c2.\u00d2000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000new(argumentArray[n]);
                --n;
            }
        }
        try {
            this.callback();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (c2 != null) {
            int n = 0;
            while (n < argumentArray.length) {
                c2.o000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000super(argumentArray[n]);
                ++n;
            }
        }
        long l2 = -1L;
        if (this.getReturnArgument() != null) {
            l2 = this.getReturnArgument().storeToRAM();
        }
        return l2;
    }

    private int getArgumentsLength() {
        Argument[] argumentArray = this.getArguments();
        if (argumentArray != null) {
            int n = 0;
            int n2 = 0;
            while (n2 < argumentArray.length) {
                n += argumentArray[n2].getAlignedLength();
                ++n2;
            }
            return n;
        }
        return 0;
    }

    private int getReturnArgumentLength() {
        if (this.getReturnArgument() == null) {
            return 0;
        }
        return this.getReturnArgument().getAlignedLength();
    }

    private native long createThunk(byte var1, int var2) throws MemoryException;

    private static native void destroyThunk(long var0);
}

