/*

  Copyright (C) 2003-2005 Smardec. All rights reserved.

  http://www.smardec.com

*/

package com.smardec.asc.outlookpanel;

import java.awt.*;


/**
 * Defines the renderer interface for {@link JOutlookTabHeader} in {@link JOutlookTab}.
 */
public interface OutlookTabHeaderRenderer {
    /**
     * Returns the component whose paint() method will render the specified tab header.
     *
     * @param jOutlookTabHeader the tab header we're painting
     * @param mouseOver         indicates that the mouse is over the tab header
     * @param mousePressed      indicates that the mouse is pressed on the tab header
     * @return the component whose paint() method will render the specified tab header.
     */
    Component getOutlookTabHeaderRendererComponent(JOutlookTabHeader jOutlookTabHeader, boolean mouseOver, boolean mousePressed);
}
