/*
 * Decompiled with CFR 0.152.
 */
package unity.util;

public class HashFunc {
    public static int hash(String key, int tableSize) {
        if (key == null) {
            return 0;
        }
        int hashVal = 0;
        int i = 0;
        while (i < key.length()) {
            hashVal = 37 * hashVal + key.charAt(i);
            ++i;
        }
        if ((hashVal %= tableSize) < 0) {
            hashVal += tableSize;
        }
        return hashVal;
    }

    public static int hash(Object[] keys, int tableSize) {
        int hashVal = 0;
        int i = 0;
        while (i < keys.length) {
            Object obj = keys[i];
            int tmpVal = obj == null ? 0 : (obj instanceof Integer ? (Integer)obj % tableSize : (obj instanceof String ? HashFunc.hash((String)obj, tableSize) : HashFunc.hash(obj.toString(), tableSize)));
            hashVal ^= tmpVal;
            ++i;
        }
        return hashVal % tableSize;
    }

    public static int hash(int key, int tableSize) {
        return key % tableSize;
    }

    public static int nextPrime(int n) {
        if (n % 2 == 0) {
            ++n;
        }
        while (!HashFunc.isPrime(n)) {
            n += 2;
        }
        return n;
    }

    public static boolean isPrime(int n) {
        if (n == 2 || n == 3) {
            return true;
        }
        if (n == 1 || n % 2 == 0) {
            return false;
        }
        int i = 3;
        while (i * i <= n) {
            if (n % i == 0) {
                return false;
            }
            i += 2;
        }
        return true;
    }
}

