/*
 * Decompiled with CFR 0.152.
 */
package unity.operators;

import java.io.IOException;
import unity.functions.Aggregate_Function;
import unity.functions.Expression;
import unity.operators.Operator;
import unity.predicates.SortComparator;
import unity.relational.Relation;
import unity.relational.Tuple;

public class SortGrouper
extends Operator {
    protected Expression[] expressionList;
    protected Aggregate_Function[] functionList;
    protected SortComparator sorter;
    private Operator input;
    private Tuple lastTupleRead;

    public SortGrouper(Operator in, SortComparator sort, Expression[] exprList, Aggregate_Function[] funcList, Relation outputRelation) {
        super(new Operator[]{in}, 0, 0);
        this.input = in;
        this.sorter = sort;
        this.expressionList = exprList;
        this.functionList = funcList;
        this.setOutputRelation(outputRelation);
    }

    public void init() throws IOException {
        this.input.init();
        this.lastTupleRead = this.input.next();
        this.incrementTuplesRead();
    }

    public Tuple next() throws IOException {
        if (this.lastTupleRead == null) {
            return null;
        }
        Tuple saved = this.lastTupleRead;
        do {
            int i = 0;
            while (i < this.functionList.length) {
                this.functionList[i].add(this.lastTupleRead);
                ++i;
            }
            this.lastTupleRead = this.input.next();
        } while (this.sorter != null && this.lastTupleRead != null && this.sorter.sqlcompare(saved, this.lastTupleRead) == 0);
        Object[] vals = new Object[this.expressionList.length + this.functionList.length];
        int i = 0;
        while (i < this.expressionList.length) {
            vals[i] = this.expressionList[i].evaluate(saved);
            ++i;
        }
        i = 0;
        while (i < this.functionList.length) {
            vals[i + this.expressionList.length] = this.functionList[i].compute();
            this.functionList[i].reset();
            ++i;
        }
        return new Tuple(vals, this.getOutputRelation());
    }

    public void close() throws IOException {
        super.close();
    }

    public String toString() {
        int i;
        Relation relation = this.input.getOutputRelation();
        StringBuffer sb = new StringBuffer(300);
        sb.append("SORTGROUP: GroupBy=");
        if (this.expressionList.length == 0) {
            sb.append("(none)");
        } else {
            sb.append(this.expressionList[0].toString(relation));
            i = 1;
            while (i < this.expressionList.length) {
                sb.append(", " + this.expressionList[i].toString(relation));
                ++i;
            }
        }
        sb.append(" Aggregates: ");
        if (this.functionList.length == 0) {
            sb.append("(none)");
        } else {
            i = 0;
            while (i < this.functionList.length) {
                sb.append(String.valueOf(this.functionList[i].toString(relation, this.outputRelation.getAttribute(this.expressionList.length + i))) + " ");
                ++i;
            }
        }
        return sb.toString();
    }
}

