/*
 * Decompiled with CFR 0.152.
 */
package unity.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import unity.annotation.AnnotatedSourceDatabase;
import unity.globalschema.GlobalSchema;
import unity.jdbc.UnityConnection;
import unity.jdbc.UnityResultSet;
import unity.parser.GlobalParser;
import unity.query.Evaluator;
import unity.query.GlobalQuery;
import unity.query.LocalQuery;
import unity.query.Optimizer;

public class UnityStatement
implements Statement {
    private UnityConnection unityconn = null;
    private int _resultSetType = 0;
    private int _resultSetConcurrency = 0;
    private ResultSet _results = null;
    private ResultSet _nextResults = null;
    private SQLWarning _warnings = null;
    private int _timeout = 0;
    private int _maxFieldSize = 0;
    private int _maxRows = 0;
    private GlobalSchema schema;
    int CLOSE_CURRENT_RESULT = 1;
    int KEEP_CURRENT_RESULT = 2;
    int CLOSE_ALL_RESULTS = 3;
    int SUCCESS_NO_INFO = -2;
    int EXECUTE_FAILED = -3;
    int RETURN_GENERATED_KEYS = 1;
    int NO_GENERATED_KEYS = 2;

    public UnityStatement(UnityConnection cnt, int resultSetType, int resultSetConcurrency, GlobalSchema gs) {
        this.unityconn = cnt;
        this._resultSetType = resultSetType;
        this._resultSetConcurrency = resultSetConcurrency;
        this.schema = gs;
    }

    public ResultSet executeQuery(String semantic) throws SQLException {
        GlobalParser kingParser = new GlobalParser();
        GlobalQuery gq = kingParser.parse(semantic, this.schema);
        Optimizer opt = new Optimizer(gq);
        gq = opt.optimize();
        Evaluator eval = new Evaluator(gq);
        UnityResultSet resultsUnity = eval.execute(this._resultSetType, this._resultSetConcurrency);
        resultsUnity.setStatement(this);
        this._results = resultsUnity;
        return resultsUnity;
    }

    public int executeUpdate(String sql) throws SQLException {
        throw new SQLException("Method not currently supported. Please use updatable ResultSet");
    }

    public void close() throws SQLException {
        if (this._results != null) {
            this._results.close();
        }
    }

    public int getMaxFieldSize() throws SQLException {
        return this._maxFieldSize;
    }

    public void setMaxFieldSize(int max) throws SQLException {
        this._maxFieldSize = max;
    }

    public int getMaxRows() throws SQLException {
        return this._maxRows;
    }

    public void setMaxRows(int max) throws SQLException {
        this._maxRows = max;
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
    }

    public int getQueryTimeout() throws SQLException {
        return this._timeout;
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        this._timeout = seconds;
    }

    public void cancel() throws SQLException {
    }

    public SQLWarning getWarnings() throws SQLException {
        return this._warnings;
    }

    public void clearWarnings() throws SQLException {
        this._warnings = null;
    }

    public void setCursorName(String name) throws SQLException {
    }

    public boolean execute(String sql) throws SQLException {
        return false;
    }

    public ResultSet getResultSet() throws SQLException {
        return this._results;
    }

    public int getUpdateCount() throws SQLException {
        return -1;
    }

    public boolean getMoreResults() throws SQLException {
        if (this._results != null) {
            this._results.close();
        }
        this._results = this._nextResults;
        this._nextResults = null;
        return false;
    }

    public void setFetchDirection(int direction) throws SQLException {
    }

    public int getFetchDirection() throws SQLException {
        return 0;
    }

    public void setFetchSize(int rows) throws SQLException {
    }

    public int getFetchSize() throws SQLException {
        return 0;
    }

    public int getResultSetConcurrency() throws SQLException {
        return this._resultSetConcurrency;
    }

    public int getResultSetType() throws SQLException {
        return this._resultSetType;
    }

    public void addBatch(String sql) throws SQLException {
    }

    public void clearBatch() throws SQLException {
    }

    public int[] executeBatch() throws SQLException {
        return null;
    }

    public Connection getConnection() throws SQLException {
        return this.unityconn;
    }

    public boolean getMoreResults(int current) throws SQLException {
        return false;
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        return null;
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return 0;
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return 0;
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return 0;
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLException("Method not implemented");
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLException("Method not currently implemented");
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new SQLException("Method not currently implemented");
    }

    public int getResultSetHoldability() throws SQLException {
        return 2;
    }

    public ResultSet executeByPassQuery(String dbName, String sql) throws SQLException {
        AnnotatedSourceDatabase asd = this.schema.getDB(dbName);
        if (asd == null) {
            throw new SQLException("Unknown database: " + dbName + " given for by-pass query.");
        }
        LocalQuery lq = new LocalQuery(asd);
        lq.setResultSetType(this._resultSetType);
        lq.setResultSetConcurrency(this._resultSetConcurrency);
        lq.setSQLQueryString(sql);
        lq.execute();
        return lq.getResultSet();
    }

    public int executeByPassUpdate(String dbName, String sql) throws SQLException {
        AnnotatedSourceDatabase asd = this.schema.getDB(dbName);
        Connection con = asd.getConnection();
        Statement stmt = con.createStatement();
        return stmt.executeUpdate(sql);
    }

    public GlobalQuery parseQuery(String sql) throws SQLException {
        GlobalParser kingParser = new GlobalParser();
        GlobalQuery gq = kingParser.parse(sql, this.schema);
        Optimizer opt = new Optimizer(gq);
        gq = opt.optimize();
        return gq;
    }

    public ResultSet executeQuery(GlobalQuery gq) throws SQLException {
        Evaluator eval = new Evaluator(gq);
        UnityResultSet resultsUnity = eval.execute(this._resultSetType, this._resultSetConcurrency);
        resultsUnity.setStatement(this);
        return resultsUnity;
    }
}

