/*
 * Decompiled with CFR 0.152.
 */
package unity.annotation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import unity.annotation.CommonMethods;
import unity.annotation.SourceDatabase;
import unity.annotation.SourceField;
import unity.annotation.SourceForeignKey;
import unity.annotation.SourceJoin;
import unity.annotation.SourceKey;
import unity.util.StringFunc;

public class SourceTable {
    protected String tableName;
    protected String schemaName;
    protected String catalogName;
    protected String comment;
    protected int numTuples;
    protected SourceDatabase parentDatabase;
    protected HashMap sourceFields = new HashMap();
    protected SourceKey primaryKey;
    protected ArrayList foreignKeys = new ArrayList();
    protected ArrayList candidateKeys = new ArrayList();
    protected ArrayList sourceJoins = new ArrayList();

    public SourceTable() {
    }

    public SourceTable(String catName, String schName, String tblName, String com, HashMap fields, SourceKey pkey) {
        this.catalogName = catName;
        this.schemaName = schName;
        this.tableName = tblName;
        this.comment = com;
        this.sourceFields = fields;
        this.primaryKey = pkey;
    }

    public SourceDatabase getParentDatabase() {
        return this.parentDatabase;
    }

    public void setParentDatabase(SourceDatabase db) {
        this.parentDatabase = db;
    }

    public boolean isPrimaryKey(ArrayList fields) {
        return this.primaryKey.matchKeyFields(fields);
    }

    public ArrayList isForeignKey(ArrayList fields) {
        ArrayList<SourceForeignKey> result = new ArrayList<SourceForeignKey>();
        int i = 0;
        while (i < this.foreignKeys.size()) {
            SourceForeignKey sfk = (SourceForeignKey)this.foreignKeys.get(i);
            if (sfk.matchKeyFields(fields)) {
                result.add(sfk);
            }
            ++i;
        }
        return result;
    }

    public boolean isForeignKey(ArrayList fields, SourceTable table) {
        int i = 0;
        while (i < this.foreignKeys.size()) {
            SourceForeignKey sfk = (SourceForeignKey)this.foreignKeys.get(i);
            if (sfk.getToSourceTable() == table && sfk.matchKeyFields(fields)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String name) {
        this.tableName = name;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String name) {
        this.schemaName = name;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(String name) {
        this.catalogName = name;
    }

    public String getFullName() {
        return String.valueOf(this.parentDatabase.getDatabaseName()) + "." + this.getNameWithSchema();
    }

    public String getNameWithSchema() {
        String output = "";
        if (this.schemaName != null && !this.schemaName.equals("")) {
            output = String.valueOf(this.schemaName) + ".";
        }
        output = String.valueOf(output) + this.tableName;
        return output;
    }

    public String getSQLTableName() {
        return StringFunc.delimitName(this.tableName);
    }

    public String getSQLTableNameWithSchema() {
        String output = "";
        if (this.schemaName != null && !this.schemaName.equals("")) {
            output = String.valueOf(output) + StringFunc.delimitName(this.schemaName) + ".";
        }
        output = String.valueOf(output) + StringFunc.delimitName(this.tableName);
        return output;
    }

    public String getFullSQLTableName() {
        return String.valueOf(this.getParentDatabase().getDatabaseName()) + "." + this.getSQLTableNameWithSchema();
    }

    public HashMap getSourceFields() {
        return this.sourceFields;
    }

    public void setSourceFields(HashMap fields) {
        this.sourceFields = fields;
    }

    public SourceKey getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(SourceKey key) {
        this.primaryKey = key;
    }

    public void setForeignKeys(ArrayList fkey) {
        this.foreignKeys = fkey;
    }

    public void addForeignKey(SourceForeignKey fkey) {
        this.foreignKeys.add(fkey);
    }

    public ArrayList getForeignKeys() {
        return this.foreignKeys;
    }

    public ArrayList getCandidateKeys() {
        return this.candidateKeys;
    }

    public ArrayList getJoins() {
        return this.sourceJoins;
    }

    public void setJoins(ArrayList joins) {
        this.sourceJoins = joins;
    }

    public int getNumTuples() {
        return this.numTuples;
    }

    public void setNumTuples(int t) {
        this.numTuples = t;
    }

    public void addJoin(SourceJoin join) {
        this.sourceJoins.add(join);
    }

    public SourceField getField(String fieldName) {
        return (SourceField)this.sourceFields.get(fieldName);
    }

    public void addField(SourceField field) {
        this.sourceFields.put(field.getColumnName().toLowerCase(), field);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(5000);
        buf.append("Table: " + this.tableName + "  Schema: " + this.schemaName + "  Catalog: " + this.catalogName + "\n");
        buf.append("   Number of tuples: " + this.numTuples + "\n");
        Iterator fields = this.sourceFields.values().iterator();
        while (fields.hasNext()) {
            buf.append(fields.next() + "\n");
        }
        buf.append(this.primaryKey);
        return buf.toString();
    }

    public String toXML() {
        StringBuffer buf = new StringBuffer(300);
        buf.append("        <tableName>" + this.tableName + "</tableName>\n");
        buf.append("        <schemaName>" + CommonMethods.exportString(this.schemaName) + "</schemaName>\n");
        buf.append("        <catalogName>" + CommonMethods.exportString(this.catalogName) + "</catalogName>\n");
        buf.append("        <comment>" + CommonMethods.exportString(this.comment) + "</comment>\n");
        buf.append("        <numTuples>" + this.numTuples + "</numTuples>");
        return buf.toString();
    }
}

