/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.queryproc;

import com.edb.gridsql.common.util.Property;
import com.edb.gridsql.common.util.Props;
import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.ProducerSender;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.exception.ErrorMessageRepository;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.planner.StepDetail;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Iterator;

public class QueryCombiner {
    private static final XLogger logger = XLogger.getLogger(QueryCombiner.class);
    private XDBSessionContext client;
    private Connection oConn;
    private boolean bTempCreated = false;
    private String sTempTableName;
    public String sCreateStatement;
    private long insCount;
    private int iBatchCount;
    private Statement stmt;
    private static final boolean USEBATCHES = true;
    private static final boolean AUTOCOMMIT = false;
    private static final int BATCHSIZE = 1000;
    private static final boolean JUST_DATA_VALUES = Property.getBoolean("xdb.message.data.justvalues", false);

    public QueryCombiner(XDBSessionContext xDBSessionContext, String string) {
        this.client = xDBSessionContext;
        this.oConn = xDBSessionContext.getAndSetCoordinatorConnection();
        try {
            this.oConn.setAutoCommit(false);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.sTempTableName = string;
        this.insCount = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String string) throws SQLException {
        Statement statement = this.oConn.createStatement();
        statement.executeUpdate(string);
        if (!this.oConn.getAutoCommit()) {
            this.oConn.commit();
        }
        statement.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void createTempTable() {
        block8: {
            if (this.bTempCreated) {
                return;
            }
            try {
                this.execute(this.sCreateStatement);
            }
            catch (SQLException sQLException) {
                if (!this.handleSqlException(sQLException, this.sCreateStatement)) break block8;
                try {
                    this.execute(this.sCreateStatement);
                    if (Props.XDB_COMMIT_AFTER_CREATE_TEMP_TABLE) {
                        this.oConn.commit();
                    }
                }
                catch (SQLException sQLException2) {
                    XDBServerException xDBServerException = new XDBServerException(ErrorMessageRepository.SQL_EXEC_FAILURE + " (" + this.sCreateStatement + ") ", sQLException2, ErrorMessageRepository.SQL_EXEC_FAILURE_CODE);
                    logger.throwing(xDBServerException);
                    throw xDBServerException;
                }
            }
        }
        this.bTempCreated = true;
    }

    private void doInsertFromStatement(String string) throws SQLException {
        String string2 = "";
        string2 = JUST_DATA_VALUES ? "INSERT INTO " + this.sTempTableName + " VALUES " + string : string;
        this.stmt.addBatch(string2);
        ++this.insCount;
        if (++this.iBatchCount % 1000 == 0) {
            this.stmt.executeBatch();
            this.iBatchCount = 0;
            this.stmt.close();
            this.stmt = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void insertFromStatementOnCombiner(String string) {
        block12: {
            block11: {
                if (this.stmt == null) {
                    try {
                        this.stmt = this.oConn.createStatement();
                    }
                    catch (SQLException sQLException) {
                        if (!this.handleSqlException(sQLException, null)) break block11;
                        try {
                            this.stmt = this.oConn.createStatement();
                        }
                        catch (SQLException sQLException2) {
                            throw new XDBServerException(ErrorMessageRepository.SQL_STATEMENT_CREATE_FAILURE, sQLException, ErrorMessageRepository.SQL_STATEMENT_CREATE_FAILURE_CODE);
                        }
                    }
                }
            }
            try {
                this.doInsertFromStatement(string);
            }
            catch (SQLException sQLException) {
                if (!this.handleSqlException(sQLException, string)) break block12;
                try {
                    this.doInsertFromStatement(string);
                }
                catch (SQLException sQLException3) {
                    throw new XDBServerException(ErrorMessageRepository.SQL_EXEC_FAILURE + " ( " + string + ")", sQLException3, ErrorMessageRepository.SQL_EXEC_FAILURE_CODE);
                }
            }
        }
    }

    public long getRowCount() {
        return this.insCount;
    }

    private void doFinishInserts() throws SQLException {
        if (this.iBatchCount > 0) {
            this.stmt.executeBatch();
            this.stmt.close();
            this.stmt = null;
        }
        if (!this.oConn.getAutoCommit()) {
            this.oConn.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void finishInserts() {
        block6: {
            try {
                this.doFinishInserts();
            }
            catch (SQLException sQLException) {
                if (!this.handleSqlException(sQLException, null)) break block6;
                try {
                    this.doFinishInserts();
                }
                catch (SQLException sQLException2) {
                    throw new XDBServerException(ErrorMessageRepository.SQL_EXEC_FAILURE, sQLException2, ErrorMessageRepository.SQL_EXEC_FAILURE_CODE);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSet doQuery(String string) throws SQLException {
        Statement statement = this.oConn.createStatement();
        ResultSet resultSet = statement.executeQuery(string);
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ResultSet queryOnCoord(String string) {
        ResultSet resultSet;
        block6: {
            resultSet = null;
            try {
                resultSet = this.doQuery(string);
            }
            catch (SQLException sQLException) {
                if (!this.handleSqlException(sQLException, string)) break block6;
                try {
                    resultSet = this.doQuery(string);
                }
                catch (SQLException sQLException2) {
                    throw new XDBServerException(ErrorMessageRepository.SQL_EXEC_FAILURE + " (" + string + ")", sQLException2, ErrorMessageRepository.SQL_EXEC_FAILURE_CODE);
                }
            }
        }
        ResultSet resultSet2 = resultSet;
        return resultSet2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void queryOnCoordAndSendToNodes(String string, StepDetail stepDetail, ProducerSender producerSender) throws SQLException {
        ResultSet resultSet = this.queryOnCoord(string);
        if (resultSet != null) {
            producerSender.sendToNodes(resultSet, stepDetail, this.oConn, Props.XDB_COORDINATOR_NODE, this.client.getRequestId());
            resultSet.close();
        }
        this.dropTempTables(stepDetail.dropList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void dropTempTables(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string = "DROP TABLE " + iterator.next();
            try {
                this.execute(string);
            }
            catch (SQLException sQLException) {
                try {
                    this.oConn.rollback();
                }
                catch (SQLException sQLException2) {}
            }
        }
    }

    private boolean handleSqlException(SQLException sQLException, Object object) {
        Object object2;
        logger.catching(sQLException);
        switch (sQLException.getErrorCode()) {
            case -708: {
                if (this.client.isPersistent()) break;
                this.oConn = this.client.resetCoordinatorConnection();
                return true;
            }
            case -4004: {
                String string;
                String string2;
                if (!(object instanceof String) || ((String)(object2 = ((String)object).trim())).length() <= 5 || !(string2 = ((String)object2).substring(0, 4).toUpperCase()).equals("DROP") || ((String)(object2 = ((String)object2).substring(5).trim())).length() <= 6 || !(string = ((String)object2).substring(0, 5).toUpperCase()).equals("TABLE")) break;
                return false;
            }
        }
        if (("57P01".equals(sQLException.getSQLState()) || "08006".equals(sQLException.getSQLState())) && !this.client.isPersistent()) {
            this.oConn = this.client.resetCoordinatorConnection();
            return true;
        }
        object2 = new XDBServerException(ErrorMessageRepository.SQL_EXEC_FAILURE + " (" + object + ")", sQLException, ErrorMessageRepository.SQL_EXEC_FAILURE_CODE);
        logger.throwing((Throwable)object2);
        throw object2;
    }
}

